//
// = FILENAME
//    StatWindow.java
//
// = FUNCTION
//    Shows status collected for clients by MinesweepEngine. 
//
// = AUTHOR(S)
//    Patric Jensfelt
//    Modifications by Oscar Sundbom
//
// = COPYRIGHT
//    Copyright (c) 2006 Patric Jensfelt
//
/*----------------------------------------------------------------------*/

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/**
 * Shows the statistics from minesweep
 *
 * @author Patric Jensfelt
 * @see
 */
class StatWindow extends JFrame implements ActionListener {
    private MinesweepEngine m_Engine;

    private JTextField m_TeamName1 = null;
    private JTextField m_TeamName2 = null;

    private JTextField m_NumGamesText = null;
    
    private JTextField m_NumWins1Text = null;
    private JTextField m_NumWins2Text = null;
    
    private JTextField m_AvgFrac1Text = null;
    private JTextField m_AvgFrac2Text = null;
    
    private JTextField m_TimeText = null;
    private JTextField m_MaxTimeText = null;
    
    public StatWindow(MinesweepEngine engine) {
        setTitle("Statistics");
        setLayout(new BorderLayout());

        m_Engine = engine;

        JPanel stats = new JPanel();
        stats.setLayout(new GridLayout(6,3));

        JLabel jl;

        jl = new JLabel(""); stats.add(jl);
        jl = new JLabel("Player1"); stats.add(jl);
        jl = new JLabel("Player2"); stats.add(jl);
        
        jl = new JLabel("Name"); stats.add(jl);
        m_TeamName1 = new JTextField("Player1"); stats.add(m_TeamName1);
        m_TeamName2 = new JTextField("Player2"); stats.add(m_TeamName2);
        
        jl = new JLabel("#wins"); stats.add(jl);
        m_NumWins1Text = new JTextField("0"); stats.add(m_NumWins1Text);
        m_NumWins1Text.setEditable(false);
        m_NumWins2Text = new JTextField("0"); stats.add(m_NumWins2Text);
        m_NumWins2Text.setEditable(false);

        jl = new JLabel("avg %"); stats.add(jl);
        m_AvgFrac1Text = new JTextField("0"); stats.add(m_AvgFrac1Text);
        m_AvgFrac1Text.setEditable(false);
        m_AvgFrac2Text = new JTextField("0"); stats.add(m_AvgFrac2Text);
        m_AvgFrac2Text.setEditable(false);

        stats.add(new JLabel("#games"));
        m_NumGamesText = new JTextField("0");
        m_NumGamesText.setEditable(false);
        stats.add(m_NumGamesText);
        stats.add(new JLabel(""));

        stats.add(new JLabel("Time"));
        m_TimeText = new JTextField("0s"); stats.add(m_TimeText);
        m_TimeText.setEditable(false);
        m_MaxTimeText = new JTextField("300s"); stats.add(m_MaxTimeText);
        m_MaxTimeText.setEditable(false);

        add(stats, BorderLayout.NORTH);
        JButton but = new JButton("Stop");
        but.addActionListener(this);
        add(but, BorderLayout.SOUTH);

        //clearStats();

        pack();
    }

    public void actionPerformed(ActionEvent e) {
        if ("Stop".equals(e.getActionCommand())) {
            System.out.println("Stopping game");
            m_Engine.stopGame();
        } else {
            System.out.println("Not trapping cmd \"" + 
                               e.getActionCommand() + "\"");
        }
    }

    public void updateStats() {
		int clients = m_Engine.getNumClients();
		String teamNames[] = {"-", "-"};
		int teamWins[] = {0, 0};
		double teamFracs[] = {0, 0};
		int numGames = 0;
		
		for(int i=0;i!=clients;++i) {
			MinesweepEngine.AgentClient c = m_Engine.getClient(i);
			teamNames[i] = c.getName();
			teamWins[i] = c.getNumWins();
			teamFracs[i] = c.getAvgScore();
			numGames = Math.max(numGames, c.getNumGames());
		}
		
		m_TeamName1.setText(teamNames[0]);
		m_TeamName2.setText(teamNames[1]);

		m_NumGamesText.setText(Integer.toString(numGames));
		m_NumWins1Text.setText(Integer.toString(teamWins[0]));
		m_NumWins2Text.setText(Integer.toString(teamWins[1]));

		m_AvgFrac1Text.setText(String.format("%.2f", teamFracs[0] * 100.0));
		m_AvgFrac2Text.setText(String.format("%.2f", teamFracs[1] * 100.0));
    }
    
    public void updateTimes() {
		int clients = m_Engine.getNumClients();
		long teamTimes[] = {m_Engine.getGameTimeSec(), m_Engine.getMaxGameTimeSec()};

		for(int i=0;i!=clients;++i) {
			MinesweepEngine.AgentClient c = m_Engine.getClient(i);
			teamTimes[i] = c.getTotalUsedTimeSecs();
		}

		m_TimeText.setText(teamTimes[0] + "s");
		m_MaxTimeText.setText(teamTimes[1] + "s");
    }
};

