//
// = FILENAME
//    StupidAgent.java
//
// = FUNCTION
//    Opens squares sequentially
// 
// = AUTHOR(S)
//    Patric Jensfelt
//
// = COPYRIGHT
//    Copyright (c) 2006 Patric Jensfelt
//
/*----------------------------------------------------------------------*/

class StupidAgent implements MineAgent {
    
    private boolean m_Opened[] = null;
    private int m_XSize;
    private int m_YSize;

    private boolean m_TryPeeking = true;

    public StupidAgent()
    {
        m_Opened = null;
    }
    
    /**
     * @param numPlayers tells how many players are playing this game
     * @param playerID the id for this player in the game
     * @param xsize number of squares in the horizontal direction
     * @param ysize number of squares in the vertical direction 
     * @param deadCost cost to die
     * @param peekCost the cos to take a peek at a square
     * 
     * @return true if initialization went ok
     */
    public boolean startNewGame(int numPlayers, int playerID,
                                int xsize, int ysize,
                                int deadCost, int peekCost)
    {
        //System.out.println("StupidAgent::startNewGame");

        m_XSize = xsize;
        m_YSize = ysize;

        m_Opened = new boolean[xsize*ysize];
        for (int i = 0; i < xsize; i++) {
            for (int j = 0; j < ysize; j++) {
                m_Opened[i+j*xsize] = false;
            }
        }

        return true;
    }
    
    /**
     * @return the move suggested by this agent given the information
     * it has gathered so far
     */
    public MineMove getNextMove()
    {
        //System.out.println("StupidAgent::getNextMove");

        MineMove mm = new MineMove(MineMove.OPEN_SQUARE);

        if (m_TryPeeking) {
            mm.m_Move = MineMove.PEEK_SQUARE;
            mm.m_X = 0;
            mm.m_Y = 0;
            System.out.println("Peeking");
            return mm;
        }

        for (int i = 0; i < m_XSize; i++) {
            for (int j = 0; j < m_YSize; j++) {
                if (m_Opened[i+j*m_XSize] == false) {
                    mm.m_X = i;
                    mm.m_Y = j;
                    m_Opened[i+j*m_XSize] = true;
                    return mm;
                }
            }
        }
        
        mm.m_Move = MineMove.STOP;
        return mm;
    }
    
    
    /**
     * This function is called by the system after a square is opened,
     * another player has died or stopped playing.
     *
     * @param info information about the game
     */
    public void handleInfo(MineInfo info)
    {
        //System.out.println("StupidAgent::handleInfo " + info.m_InfoType);
        if (info.m_InfoType == MineInfo.ALREADY_PEEKED) {
            m_TryPeeking = false;
            System.out.println("Not allowed to peek anymore");
        } else if (info.m_InfoType == MineInfo.SQUARE_INFO) {
            //System.out.println("Square info : " + info.m_Value);
        }
    }

};
