//
// = FILENAME
//    Minesweep.java
//
// = FUNCTION
//
//    This is the main control for the mine sweep process. You can run it in 
//    three different modes:
//    1. Manual mode: user clicks on the mines
//    2. Auto mode  : agent plays
//    3. Server mode: agent can connect via sockets and play
// 
// = AUTHOR(S)
//    Patric Jensfelt
//    Modifications by Oscar Sundbom
//
// = COPYRIGHT
//    Copyright (c) 2005 Patric Jensfelt
//
/*----------------------------------------------------------------------*/

import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.JFrame;

public class Minesweep {

    public static void main(String[] args) {

        int port = 5555;
        if (args.length >= 1) {
            try {
                port = Integer.parseInt(args[0]);
            } catch (Exception e) {
                System.out.println("Could not get port number for server\n" +
                                   "args: <Port> <NumPlayers>");
                System.exit(0);
            }
        }

        int numplayers = 1;
        if (args.length >= 2) {
            try {
                numplayers = Integer.parseInt(args[1]);
                if (numplayers < 1 || numplayers > 2) {
                    System.out.println("Only allowing 1 or 2 player\n" +
                                       "args: <Port> <NumPlayers (1/2)>");
                    System.exit(0);
                }
            } catch (Exception e) {
                System.out.println("Could not get number of players\n" +
                                   "args: <Port> <NumPlayers (1/2)>");
                System.exit(0);
            }
        }

        MinesweepEngine engine = new MinesweepEngine(port, 40, 20, 0.04, 10, 10);
        MinesweepGUI frame = new MinesweepGUI(engine);
        frame.setTwoPlayerGame((numplayers==2));

        Dimension d = frame.getSize();

        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((int)(screenSize.width/2 - d.getWidth()/2),
                          (int)(screenSize.height/2 - d.getHeight()/2));
        frame.setVisible(true);
    }

};

