//
// = FILENAME
//    MinesweepUI.java
//
// = FUNCTION
//    Base for user interfaces to MinesweepEngine.    
// 
// = AUTHOR(S)
//    Oscar Sundbom
//
// = COPYRIGHT
//    Copyright (c) 2007 Oscar Sundbom
//
/*----------------------------------------------------------------------*/

public interface MinesweepUI {

	/**	 Messages that might interrupt the flow of the program */
	public static final int LEVEL_NOTIFY   = 1;	

	/**	 Error messages */
	public static final int LEVEL_ERROR    = 2;

	/**	 Warning messages */
	public static final int LEVEL_WARNING  = 3;

	/**	 Informational messages that are _NOT_ allowed to interrupt the flow of the program */
	public static final int LEVEL_INFO     = 4;

	/**	 Debug messages */
	public static final int LEVEL_DEBUG    = 5;
	
	public void showMessage(String msg, int level);
	
	public void batchRunEnded();
}
