/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class DiffDriveRobotModel {
    private double m_Time;
    private Pose m_TruePose = new Pose();
    private Pose m_SensorPoseR = new Pose();
    private double m_ImagEncR;
    private double m_ImagEncL;
    private double m_CurrSpeedV;
    private double m_CurrSpeedW;
    private Odometry m_Odom = new Odometry();
    private double m_RadiusR;
    private double m_RadiusL;
    private double m_WheelBase;
    private double m_NomRadiusR;
    private double m_NomRadiusL;
    private double m_NomWheelBase;
    private boolean m_UseTrueWheelParamsForWheelSpeeds;
    private int m_EncTicksPerRev;
    private double m_MaxV;
    private double m_MaxW;
    private double m_MaxAccV;
    private double m_MaxAccW;
    private double m_AddNoiseStdAccV;
    private double m_AddNoiseStdAccW;
    private double m_MultNoiseStdAccV;
    private double m_MultNoiseStdAccW;
    private double m_MotionDT;
    private int m_NumMotionStepPerCtrlCmd;
    private Random m_RandGen = null;

    public DiffDriveRobotModel() {
        this.m_Odom.m_Pose = new Pose();
        this.m_RandGen = new Random(System.currentTimeMillis());
        this.m_Time = 0.0;
        this.m_RadiusR = 0.1;
        this.m_RadiusL = 0.1;
        this.m_WheelBase = 0.35;
        this.m_NomRadiusR = this.m_RadiusR;
        this.m_NomRadiusL = this.m_RadiusL;
        this.m_NomWheelBase = this.m_WheelBase;
        this.m_MaxAccV = 0.5;
        this.m_MaxAccW = 0.5;
        this.m_MaxV = 1.0;
        this.m_MaxW = 0.5;
        this.m_EncTicksPerRev = 2048;
        this.setSimMeasTimeStep(0.2);
        this.m_AddNoiseStdAccV = 0.0;
        this.m_AddNoiseStdAccW = 0.0;
        this.m_MultNoiseStdAccV = 0.0;
        this.m_MultNoiseStdAccW = 0.0;
        this.m_CurrSpeedV = 0.0;
        this.m_CurrSpeedW = 0.0;
        this.zeroOdometry();
    }

    public void setSimMeasTimeStep(double d) {
        this.m_NumMotionStepPerCtrlCmd = 10;
        this.m_MotionDT = d / (double)this.m_NumMotionStepPerCtrlCmd;
        if (this.m_MotionDT > 0.01) {
            this.m_NumMotionStepPerCtrlCmd = (int)(d / 0.01 + 0.5);
            this.m_MotionDT = d / (double)this.m_NumMotionStepPerCtrlCmd;
        }
        System.err.println("DiffDriveRobotModel: Simulation step set to " + d + "s (internal sim step " + this.m_MotionDT + "s)");
    }

    public void configKinematics(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m_RadiusR = d;
        this.m_RadiusL = d2;
        this.m_WheelBase = d3;
        this.m_NomRadiusR = d4;
        this.m_NomRadiusL = d5;
        this.m_NomWheelBase = d6;
    }

    public void setEncoderResolution(int n) {
        this.m_EncTicksPerRev = n;
    }

    public void setUseTrueWheelParamsForWheelSpeeds(boolean bl) {
        this.m_UseTrueWheelParamsForWheelSpeeds = bl;
    }

    public void setMaxSpeeds(double d, double d2) {
        this.m_MaxV = d;
        this.m_MaxW = d2;
    }

    public void setMaxAccelerations(double d, double d2) {
        this.m_MaxAccV = d;
        this.m_MaxAccV = d2;
    }

    public void setAccelerationNoise(double d, double d2, double d3, double d4) {
        this.m_AddNoiseStdAccV = d;
        this.m_AddNoiseStdAccW = d2;
        this.m_MultNoiseStdAccV = d3;
        this.m_MultNoiseStdAccW = d4;
    }

    public void resetTruePose(Pose pose) {
        this.m_TruePose.setPose(pose);
    }

    public void setSensorPose(Pose pose) {
        this.m_SensorPoseR.setPose(pose);
    }

    public void zeroOdometry() {
        this.m_ImagEncR = 0.0;
        this.m_ImagEncL = 0.0;
        this.m_Odom.m_Pose.setPose(0.0, 0.0, 0.0);
        this.m_Odom.m_EncR = 0L;
        this.m_Odom.m_EncL = 0L;
    }

    public void fullSimulationReset() {
        this.resetTruePose(new Pose());
        this.zeroOdometry();
        this.m_CurrSpeedV = 0.0;
        this.m_CurrSpeedW = 0.0;
        this.m_Time = 0.0;
    }

    public double getTime() {
        return this.m_Time;
    }

    public Pose getTruePose() {
        return this.m_TruePose;
    }

    public Odometry getOdometry() {
        return this.m_Odom;
    }

    public Pose getSensorPoseRobot() {
        return this.m_SensorPoseR;
    }

    public Pose getSensorPoseOdom() {
        return new Pose(this.m_Odom.m_Pose.compound(this.m_SensorPoseR));
    }

    public Pose getSensorPoseTrue() {
        return new Pose(this.m_TruePose.compound(this.m_SensorPoseR));
    }

    public double getMaxSpeedTrans() {
        return this.m_MaxV;
    }

    public double getMaxSpeedRot() {
        return this.m_MaxW;
    }

    public double getMaxAccelerationTrans() {
        return this.m_MaxAccV;
    }

    public double getMaxAccelerationRot() {
        return this.m_MaxAccW;
    }

    public double setRefSpeedsAndUpdate(double d, double d2) {
        double d3 = this.m_MotionDT;
        for (int i = 0; i < this.m_NumMotionStepPerCtrlCmd; ++i) {
            double d4;
            double d5;
            this.m_Time += this.m_MotionDT;
            if (this.m_UseTrueWheelParamsForWheelSpeeds) {
                d5 = (this.m_CurrSpeedV + this.m_WheelBase * this.m_CurrSpeedW / 2.0) / this.m_RadiusR;
                d4 = (this.m_CurrSpeedV - this.m_WheelBase * this.m_CurrSpeedW / 2.0) / this.m_RadiusL;
            } else {
                d5 = (this.m_CurrSpeedV + this.m_NomWheelBase * this.m_CurrSpeedW / 2.0) / this.m_NomRadiusR;
                d4 = (this.m_CurrSpeedV - this.m_NomWheelBase * this.m_CurrSpeedW / 2.0) / this.m_NomRadiusL;
            }
            double d6 = 1.0 * (double)this.m_EncTicksPerRev / (Math.PI * 2);
            double d7 = d3 * d5 * d6;
            double d8 = d3 * d4 * d6;
            this.m_ImagEncR += d7;
            this.m_ImagEncL += d8;
            long l = this.m_Odom.m_EncR;
            long l2 = this.m_Odom.m_EncL;
            this.m_Odom.m_EncR = (long)this.m_ImagEncR;
            this.m_Odom.m_EncL = (long)this.m_ImagEncL;
            double d9 = 1.0 * (double)(this.m_Odom.m_EncR - l) / d6;
            double d10 = 1.0 * (double)(this.m_Odom.m_EncL - l2) / d6;
            double d11 = (d9 * this.m_NomRadiusR + d10 * this.m_NomRadiusL) / 2.0;
            double d12 = (d9 * this.m_NomRadiusR - d10 * this.m_NomRadiusL) / this.m_NomWheelBase;
            double d13 = this.m_Odom.m_Pose.getTheta() + d12 / 2.0;
            this.m_Odom.m_Pose.setX(this.m_Odom.m_Pose.getX() + d11 * Math.cos(d13));
            this.m_Odom.m_Pose.setY(this.m_Odom.m_Pose.getY() + d11 * Math.sin(d13));
            this.m_Odom.m_Pose.setTheta(this.m_Odom.m_Pose.getTheta() + d12);
            this.m_Odom.m_Time = this.m_Time;
            double d14 = (d5 * this.m_RadiusR + d4 * this.m_RadiusL) / 2.0;
            double d15 = (d5 * this.m_RadiusR - d4 * this.m_RadiusL) / this.m_WheelBase;
            d13 = this.m_TruePose.getTheta() + d3 * d15 / 2.0;
            this.m_TruePose.setX(this.m_TruePose.getX() + d3 * d14 * Math.cos(d13));
            this.m_TruePose.setY(this.m_TruePose.getY() + d3 * d14 * Math.sin(d13));
            this.m_TruePose.setTheta(this.m_TruePose.getTheta() + d3 * d15);
            this.limitAnglesToPlusMinusPI();
            this.calcNewSpeed(d, d2, d3);
        }
        return this.m_Time;
    }

    private void limitAnglesToPlusMinusPI() {
        while (this.m_Odom.m_Pose.getTheta() > Math.PI) {
            this.m_Odom.m_Pose.setTheta(this.m_Odom.m_Pose.getTheta() - Math.PI * 2);
        }
        while (this.m_Odom.m_Pose.getTheta() < -Math.PI) {
            this.m_Odom.m_Pose.setTheta(this.m_Odom.m_Pose.getTheta() + Math.PI * 2);
        }
        while (this.m_TruePose.getTheta() > Math.PI) {
            this.m_TruePose.setTheta(this.m_TruePose.getTheta() - Math.PI * 2);
        }
        while (this.m_TruePose.getTheta() < -Math.PI) {
            this.m_TruePose.setTheta(this.m_TruePose.getTheta() + Math.PI * 2);
        }
    }

    private void calcNewSpeed(double d, double d2, double d3) {
        double d4;
        if (d == 0.0 && d2 == 0.0 && this.m_CurrSpeedV == 0.0 && this.m_CurrSpeedW == 0.0) {
            return;
        }
        double d5 = (d - this.m_CurrSpeedV) / d3;
        if (d5 < -this.m_MaxAccV) {
            d5 = -this.m_MaxAccV;
        }
        if (d5 > this.m_MaxAccV) {
            d5 = this.m_MaxAccV;
        }
        if ((d4 = (d2 - this.m_CurrSpeedW) / d3) < -this.m_MaxAccW) {
            d4 = -this.m_MaxAccW;
        }
        if (d4 > this.m_MaxAccW) {
            d4 = this.m_MaxAccW;
        }
        d5 += d5 * this.m_MultNoiseStdAccV * this.m_RandGen.nextGaussian();
        d4 += d4 * this.m_MultNoiseStdAccW * this.m_RandGen.nextGaussian();
        this.m_CurrSpeedV += (d5 += this.m_AddNoiseStdAccV * this.m_RandGen.nextGaussian()) * d3;
        this.m_CurrSpeedW += (d4 += this.m_AddNoiseStdAccW * this.m_RandGen.nextGaussian()) * d3;
        if (this.m_CurrSpeedV > this.m_MaxV) {
            this.m_CurrSpeedV = this.m_MaxV;
        } else if (this.m_CurrSpeedV < -this.m_MaxV) {
            this.m_CurrSpeedV = -this.m_MaxV;
        }
        if (this.m_CurrSpeedW > this.m_MaxW) {
            this.m_CurrSpeedW = this.m_MaxW;
        } else if (this.m_CurrSpeedW < -this.m_MaxW) {
            this.m_CurrSpeedW = -this.m_MaxW;
        }
    }

    public static void main(String[] stringArray) {
        DiffDriveRobotModel diffDriveRobotModel = new DiffDriveRobotModel();
        diffDriveRobotModel.configKinematics(0.101, 0.1, 0.35, 0.1, 0.1, 0.35);
        for (int i = 0; i < 100; ++i) {
            diffDriveRobotModel.setRefSpeedsAndUpdate(0.5, 0.0);
            System.out.println("" + diffDriveRobotModel.getTruePose().getX() + " " + diffDriveRobotModel.getTruePose().getY() + " " + diffDriveRobotModel.getTruePose().getTheta() + " " + diffDriveRobotModel.getOdometry().m_Pose.getX() + " " + diffDriveRobotModel.getOdometry().m_Pose.getY() + " " + diffDriveRobotModel.getOdometry().m_Pose.getTheta());
        }
    }

    public class Odometry {
        public double m_Time;
        public Pose m_Pose;
        public long m_EncR;
        public long m_EncL;
    }
}

