/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class FileGenerator {
    private DiffDriveRobotModel m_Robot = new DiffDriveRobotModel();
    private SensorModel m_Sensor = new SensorModel();
    private MotionCtrl m_Ctrl = new MotionCtrl(this.m_Robot);
    private WorldModel m_World = new WorldModel();
    private boolean m_OutputTruePose = true;
    public BufferedWriter m_Writer = null;
    public static final int TARGET_MODE_STANDSTILL = 0;
    public static final int TARGET_MODE_GOTOXY = 1;
    public static final int TARGET_MODE_TURNTO = 2;
    public static final int TARGET_MODE_JUMPTO = 3;
    private Target[] m_Targets;

    private boolean setup(ExperimentSettings experimentSettings) {
        if (!this.m_World.readLandmarksFromFile(experimentSettings.m_MapFilename)) {
            System.err.println("Could not read map file \"" + experimentSettings.m_MapFilename + "\" specified in setting " + " file " + experimentSettings.m_SourceFilename);
            return false;
        }
        if (!this.readTrajectoryFile(experimentSettings.m_TrajFilename)) {
            System.err.println("Could not read trajectory file \"" + experimentSettings.m_TrajFilename + "\" specified in setting " + " file " + experimentSettings.m_SourceFilename);
            return false;
        }
        System.out.println("Configured with trajectory with " + this.m_Targets.length + " targets");
        this.m_OutputTruePose = experimentSettings.m_OutputTruePose;
        this.m_Robot.resetTruePose(experimentSettings.m_InitRobotPoseW);
        this.m_Robot.setSensorPose(experimentSettings.m_SensorPoseR);
        this.m_Robot.configKinematics(experimentSettings.m_WheelRadR_True, experimentSettings.m_WheelRadL_True, experimentSettings.m_WheelBase_True, experimentSettings.m_WheelRadR_Model, experimentSettings.m_WheelRadL_Model, experimentSettings.m_WheelBase_Model);
        this.m_Robot.setUseTrueWheelParamsForWheelSpeeds(experimentSettings.m_UseTrueWheelParamsForWheelSpeeds);
        this.m_Robot.setEncoderResolution(experimentSettings.m_EncoderTicksPerRev);
        this.m_Robot.setMaxSpeeds(experimentSettings.m_RobotMaxSpeedV, experimentSettings.m_RobotMaxSpeedW);
        this.m_Robot.setMaxAccelerations(experimentSettings.m_RobotMaxAccV, experimentSettings.m_RobotMaxAccW);
        this.m_Robot.setAccelerationNoise(experimentSettings.m_RobotAddNoiseStdAccV, experimentSettings.m_RobotAddNoiseStdAccW, experimentSettings.m_RobotMultNoiseStdAccV, experimentSettings.m_RobotMultNoiseStdAccV);
        this.m_Robot.setSimMeasTimeStep(experimentSettings.m_SimMeasTimeStep);
        this.m_Sensor.m_AngFOV = experimentSettings.m_SensorAngFOV;
        this.m_Sensor.m_MaxRange = experimentSettings.m_SensorMaxRange;
        this.m_Sensor.setSensorNoise(experimentSettings.m_SensorNoiseStdBearing, experimentSettings.m_SensorNoiseStdRange);
        this.m_Sensor.setSensorBias(experimentSettings.m_SensorBiasBearing, experimentSettings.m_SensorBiasRange);
        this.m_Ctrl.setMaxSpeeds(experimentSettings.m_CtrlMaxSpeedV, experimentSettings.m_CtrlMaxSpeedW);
        this.m_Ctrl.setCtrlGainTrans(experimentSettings.m_CtrlGainTrans);
        this.m_Ctrl.setCtrlGainRot(experimentSettings.m_CtrlGainRot);
        this.m_Ctrl.setSpeedReductionAngleFactor(experimentSettings.m_CtrlSpeedRedAngFactor);
        this.m_World.setLandmarkDiameter(experimentSettings.m_LandmarkDiameter);
        this.m_World.setReduceRangeByLandmarkRadius(experimentSettings.m_ReduceRangeByLandmarkRadius);
        this.m_World.setUseKnownAssosiations(experimentSettings.m_KnownAssociations);
        return true;
    }

    private boolean openOutputFile(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            this.m_Writer = new BufferedWriter(fileWriter);
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.getMessage());
            this.m_Writer = null;
            return false;
        }
        return true;
    }

    private void closeOutputFile() {
        try {
            if (this.m_Writer != null) {
                this.m_Writer.close();
            }
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.getMessage());
        }
        this.m_Writer = null;
    }

    private boolean measureAndWriteLine() {
        if (this.m_Writer == null) {
            System.err.println("FileGenerator: You need to call openFile before measureAndWriteLine\n");
            return false;
        }
        WorldModel.Measurement[] measurementArray = this.m_World.getMeasurements(this.m_Robot.getSensorPoseTrue(), this.m_Sensor);
        try {
            this.m_Writer.write(this.m_Robot.getTime() + " " + this.m_Robot.getOdometry().m_Pose.getX() + " " + this.m_Robot.getOdometry().m_Pose.getY() + " " + this.m_Robot.getOdometry().m_Pose.getTheta() + " " + this.m_Robot.getOdometry().m_EncR + " " + this.m_Robot.getOdometry().m_EncL);
            if (this.m_OutputTruePose) {
                this.m_Writer.write(" " + this.m_Robot.getTruePose().getX() + " " + this.m_Robot.getTruePose().getY() + " " + this.m_Robot.getTruePose().getTheta());
            } else {
                this.m_Writer.write(" 0 0 0");
            }
            if (measurementArray != null) {
                this.m_Writer.write(" " + measurementArray.length);
                for (int i = 0; i < measurementArray.length; ++i) {
                    this.m_Writer.write(" " + measurementArray[i].m_Id + " " + measurementArray[i].m_Bearing + " " + measurementArray[i].m_Range);
                }
            } else {
                System.err.println("null pointer for measurements");
                this.m_Writer.write(" 0");
            }
            this.m_Writer.write("\n");
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.getMessage());
            return false;
        }
        return true;
    }

    private boolean readTrajectoryFile(String string) {
        try {
            int n;
            Object[] objectArray;
            String string2;
            File file = new File(string);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            int n2 = 0;
            while (bufferedReader.readLine() != null) {
                ++n2;
            }
            bufferedReader.close();
            this.m_Targets = new Target[n2];
            bufferedReader = new BufferedReader(new FileReader(file));
            int n3 = 0;
            int n4 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n4;
                if ((string2 = string2.trim()).length() == 0 || string2.charAt(0) == '#') continue;
                objectArray = string2.split(" ");
                objectArray[0] = objectArray[0].trim();
                n = 1;
                try {
                    Object[] objectArray2;
                    this.m_Targets[n3] = new Target();
                    this.m_Targets[n3].m_Mode = Integer.valueOf((String)objectArray[0]);
                    boolean bl = false;
                    if (this.m_Targets[n3].m_Mode == 0) {
                        objectArray2 = Utils.getIntArguments((String[])objectArray, 1);
                        if (objectArray2 != null) {
                            this.m_Targets[n3].m_NumIters = objectArray2[0];
                        } else {
                            System.err.println("FileGenerator:  failed to parse line " + n4 + " from file \"" + string + "\"\n");
                            bl = true;
                        }
                    } else if (this.m_Targets[n3].m_Mode == 1) {
                        objectArray2 = Utils.getDoubleArguments((String[])objectArray, 3);
                        if (objectArray2 != null) {
                            this.m_Targets[n3].setX(objectArray2[0]);
                            this.m_Targets[n3].setY(objectArray2[1]);
                            this.m_Targets[n3].m_Tol = objectArray2[2];
                        } else {
                            bl = true;
                        }
                    } else if (this.m_Targets[n3].m_Mode == 2) {
                        objectArray2 = Utils.getDoubleArguments((String[])objectArray, 2);
                        if (objectArray2 != null) {
                            this.m_Targets[n3].setTheta(objectArray2[0]);
                            this.m_Targets[n3].m_Tol = objectArray2[1];
                        } else {
                            bl = true;
                        }
                    } else if (this.m_Targets[n3].m_Mode == 3) {
                        objectArray2 = Utils.getDoubleArguments((String[])objectArray, 3);
                        if (objectArray2 != null) {
                            this.m_Targets[n3].setX(objectArray2[0]);
                            this.m_Targets[n3].setY(objectArray2[1]);
                            this.m_Targets[n3].setTheta(objectArray2[2]);
                        } else {
                            bl = true;
                        }
                    }
                    if (bl) {
                        System.err.println("FileGenerator:  failed to parse line " + n4 + " from file \"" + string + "\"\n");
                        this.m_Targets = null;
                        return false;
                    }
                    ++n3;
                }
                catch (Exception exception) {
                    System.err.println("FileGenerator: Exception when  reading trajectory file \"" + string + "\"" + " on line " + n4);
                    System.err.println("Exception: " + exception.getMessage());
                    this.m_Targets = null;
                    return false;
                }
            }
            System.out.println("File had " + n2 + " lines and found " + n3 + " targets");
            if (n3 < n2) {
                if (n3 == 0) {
                    this.m_Targets = null;
                } else {
                    objectArray = new Target[n3];
                    for (n = 0; n < n3; ++n) {
                        objectArray[n] = this.m_Targets[n];
                    }
                    this.m_Targets = objectArray;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("FileGenerator: Exception when  reading trajectory  file \"" + string + "\"");
            System.err.println("Exception: " + exception.getMessage());
            this.m_Targets = null;
            return false;
        }
        return true;
    }

    public boolean generateFile(ExperimentSettings experimentSettings, String string) {
        if (!this.setup(experimentSettings)) {
            return false;
        }
        if (!this.openOutputFile(string)) {
            return false;
        }
        if (this.m_Targets == null) {
            System.err.println("FileGenerator::generateFile no trajectory specified, cannot make any measurements\n");
            return false;
        }
        this.m_Robot.fullSimulationReset();
        System.out.print("Setting initial true pose to ");
        experimentSettings.m_InitRobotPoseW.print();
        this.m_Robot.resetTruePose(experimentSettings.m_InitRobotPoseW);
        this.measureAndWriteLine();
        for (int i = 0; i < this.m_Targets.length; ++i) {
            if (this.m_Targets[i].m_Mode == 0) {
                System.err.println("Standing still for " + this.m_Targets[i].m_NumIters + " iteraitons");
            } else if (this.m_Targets[i].m_Mode == 1) {
                System.err.println("Going to x=" + this.m_Targets[i].getX() + ", y=" + this.m_Targets[i].getY() + " with tolerance " + this.m_Targets[i].m_Tol + "m");
            } else if (this.m_Targets[i].m_Mode == 2) {
                System.err.println("Turning to theta=" + this.m_Targets[i].getTheta() + " with tolerance " + this.m_Targets[i].m_Tol + "rad");
            } else if (this.m_Targets[i].m_Mode == 3) {
                System.err.println("Jumping to x=" + this.m_Targets[i].getX() + ", y=" + this.m_Targets[i].getY() + ", theta=" + this.m_Targets[i].getTheta());
            } else {
                System.err.println("WARNING\nWARNING Not handling target mode " + this.m_Targets[i].m_Mode + " skipping it\n" + "WARNING");
                continue;
            }
            int n = 0;
            boolean bl = false;
            while (!bl) {
                ++n;
                if (this.m_Targets[i].m_Mode == 0) {
                    this.m_Robot.setRefSpeedsAndUpdate(0.0, 0.0);
                    if (n >= this.m_Targets[i].m_NumIters) {
                        bl = true;
                    }
                } else if (this.m_Targets[i].m_Mode == 1) {
                    if (this.m_Ctrl.ctrlGotoXY(this.m_Targets[i].getX(), this.m_Targets[i].getY(), this.m_Targets[i].m_Tol, false)) {
                        bl = true;
                    }
                } else if (this.m_Targets[i].m_Mode == 2) {
                    if (this.m_Ctrl.ctrlTurnTo(this.m_Targets[i].getTheta(), this.m_Targets[i].m_Tol, false)) {
                        bl = true;
                    }
                } else if (this.m_Targets[i].m_Mode == 3) {
                    this.m_Robot.resetTruePose(new Pose(this.m_Targets[i].getX(), this.m_Targets[i].getX(), this.m_Targets[i].getTheta()));
                    bl = true;
                }
                this.measureAndWriteLine();
            }
        }
        this.closeOutputFile();
        return true;
    }

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        int n = 0;
        while (n < stringArray.length) {
            if (n < stringArray.length - 1 && stringArray[n].equals("-c")) {
                string = stringArray[n + 1];
                n += 2;
                continue;
            }
            if (n < stringArray.length - 1 && stringArray[n].equals("-e")) {
                string2 = stringArray[n + 1];
                n += 2;
                continue;
            }
            System.out.println("Command line args: -c configfile");
            System.exit(1);
        }
        FileGenerator fileGenerator = new FileGenerator();
        ExperimentSettings experimentSettings = new ExperimentSettings();
        if (!experimentSettings.readFromFile(string)) {
            System.err.println("Failed to read file \"" + string + "\"");
            System.exit(1);
        }
        if (string2.length() > 0 && !experimentSettings.readFromFile(string2)) {
            System.err.println("Failed to read file \"" + string2 + "\"");
            System.exit(1);
        }
        experimentSettings.print();
        fileGenerator.generateFile(experimentSettings, experimentSettings.m_OutFilename);
    }

    private class Target
    extends Pose {
        public int m_Mode;
        public double m_Tol;
        public int m_NumIters;

        private Target() {
        }
    }
}

