/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;

public class WorldModel {
    private Landmark[] m_Landmarks = null;
    private Random m_RandGen = new Random(System.currentTimeMillis());
    private double m_LandmarkDiam = 0.1;
    private boolean m_ReduceRangeByLandmarkRadius = false;
    private boolean m_KnownAssociations = true;

    public void setLandmarkDiameter(double d) {
        this.m_LandmarkDiam = d;
    }

    public void setReduceRangeByLandmarkRadius(boolean bl) {
        this.m_ReduceRangeByLandmarkRadius = bl;
    }

    public void setUseKnownAssosiations(boolean bl) {
        this.m_KnownAssociations = bl;
        System.out.println("m_KnownAssociations=" + this.m_KnownAssociations);
    }

    public boolean readLandmarksFromFile(String string) {
        try {
            Object[] objectArray;
            String string2;
            File file = new File(string);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            int n = 0;
            while (bufferedReader.readLine() != null) {
                ++n;
            }
            bufferedReader.close();
            bufferedReader = new BufferedReader(new FileReader(file));
            this.m_Landmarks = new Landmark[n];
            int n2 = 0;
            int n3 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n3;
                if ((string2 = string2.trim()).length() == 0 || ((String)(objectArray = string2.split(" "))[0]).trim().charAt(0) == '#') continue;
                this.m_Landmarks[n2] = new Landmark();
                this.m_Landmarks[n2].m_Id = Integer.valueOf((String)objectArray[0]);
                double[] dArray = Utils.getDoubleArguments((String[])objectArray, 2);
                if (dArray != null) {
                    this.m_Landmarks[n2].m_X = dArray[0];
                    this.m_Landmarks[n2].m_Y = dArray[1];
                    ++n2;
                    continue;
                }
                System.err.println("WorldModel: Failed to parse line " + n3 + " of landmark file \"" + string + "\"");
                this.m_Landmarks = null;
                return false;
            }
            if (n2 < n) {
                if (n2 == 0) {
                    this.m_Landmarks = null;
                    System.err.println("WorldModel: Failed to read landmark file \"" + string + "\"");
                    return false;
                }
                objectArray = new Landmark[n2];
                for (int i = 0; i < n2; ++i) {
                    objectArray[i] = this.m_Landmarks[i];
                }
                this.m_Landmarks = objectArray;
            }
            System.out.println("Read " + n2 + " landmarks from \"" + string + "\"");
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            this.m_Landmarks = null;
            return false;
        }
        catch (IOException iOException) {
            this.m_Landmarks = null;
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public void printLandmarkList() {
        if (this.m_Landmarks == null) {
            return;
        }
        for (int i = 0; i < this.m_Landmarks.length; ++i) {
            if (this.m_Landmarks[i] == null) continue;
            System.out.println("id=" + this.m_Landmarks[i].m_Id + " x=" + this.m_Landmarks[i].m_X + " y=" + this.m_Landmarks[i].m_Y);
        }
    }

    public Measurement[] getMeasurements(double d, double d2, double d3, SensorModel sensorModel) {
        int n;
        if (this.m_Landmarks == null) {
            return null;
        }
        for (n = 0; n < this.m_Landmarks.length; ++n) {
            this.m_Landmarks[n].m_Range = Math.hypot(this.m_Landmarks[n].m_Y - d2, this.m_Landmarks[n].m_X - d);
            if (this.m_ReduceRangeByLandmarkRadius) {
                this.m_Landmarks[n].m_Range -= this.m_LandmarkDiam / 2.0;
            }
            this.m_Landmarks[n].m_Bearing = this.angleDiffRad(Math.atan2(this.m_Landmarks[n].m_Y - d2, this.m_Landmarks[n].m_X - d), d3);
            if (this.m_Landmarks[n].m_Range < 1.0E-6) {
                this.m_Landmarks[n].m_AngleWidth = 0.0;
                continue;
            }
            double d4 = Math.atan(this.m_LandmarkDiam / this.m_Landmarks[n].m_Range / 2.0);
            this.m_Landmarks[n].m_AngleWidth = 2.0 * d4;
        }
        n = this.updateVisibility(d, d2, d3, sensorModel);
        if (n == 0) {
            return null;
        }
        Measurement[] measurementArray = new Measurement[n];
        int n2 = 0;
        for (int i = 0; i < this.m_Landmarks.length; ++i) {
            if (!this.m_Landmarks[i].m_Visible) continue;
            if (n2 >= n) {
                System.err.println("WorldModel: Should only have found " + n + " visible, found more, skipping");
                break;
            }
            measurementArray[n2] = new Measurement();
            measurementArray[n2].m_Id = this.m_KnownAssociations ? this.m_Landmarks[i].m_Id : -1;
            measurementArray[n2].m_Bearing = this.m_Landmarks[i].m_Bearing + sensorModel.m_BiasBearing + sensorModel.m_NoiseStdBearing * this.m_RandGen.nextGaussian();
            measurementArray[n2].m_Range = this.m_Landmarks[i].m_Range + sensorModel.m_BiasRange + sensorModel.m_NoiseStdRange * this.m_RandGen.nextGaussian();
            ++n2;
        }
        if (n2 != n) {
            System.err.println("WorldModel: Logic error, did not find all measurements");
            return null;
        }
        return measurementArray;
    }

    public Measurement[] getMeasurements(Pose pose, SensorModel sensorModel) {
        return this.getMeasurements(pose.getX(), pose.getY(), pose.getTheta(), sensorModel);
    }

    private int updateVisibility(double d, double d2, double d3, SensorModel sensorModel) {
        int n;
        int n2;
        if (this.m_Landmarks == null) {
            return 0;
        }
        for (n2 = 0; n2 < this.m_Landmarks.length; ++n2) {
            if (Math.abs(this.m_Landmarks[n2].m_Bearing) <= sensorModel.m_AngFOV / 2.0 && this.m_Landmarks[n2].m_Range <= sensorModel.m_MaxRange) {
                this.m_Landmarks[n2].m_InFOV = true;
                this.m_Landmarks[n2].m_Visible = true;
                continue;
            }
            this.m_Landmarks[n2].m_InFOV = false;
            this.m_Landmarks[n2].m_Visible = false;
        }
        block1: for (n2 = 0; n2 < this.m_Landmarks.length; ++n2) {
            if (!this.m_Landmarks[n2].m_Visible) continue;
            for (n = 0; n < this.m_Landmarks.length; ++n) {
                double d4;
                if (n2 == n || !(Math.abs(d4 = this.angleDiffRad(this.m_Landmarks[n2].m_Bearing, this.m_Landmarks[n].m_Bearing)) < this.m_Landmarks[n2].m_AngleWidth + this.m_Landmarks[n].m_AngleWidth)) continue;
                if (this.m_Landmarks[n].m_Range > this.m_Landmarks[n2].m_Range) {
                    this.m_Landmarks[n].m_Visible = false;
                    continue;
                }
                this.m_Landmarks[n2].m_Visible = false;
                continue block1;
            }
        }
        n2 = 0;
        for (n = 0; n < this.m_Landmarks.length; ++n) {
            if (!this.m_Landmarks[n].m_Visible) continue;
            ++n2;
        }
        return n2;
    }

    private double angleDiffRad(double d, double d2) {
        double d3;
        for (d3 = d - d2; d3 > Math.PI; d3 -= Math.PI * 2) {
        }
        while (d3 <= -Math.PI) {
            d3 += Math.PI * 2;
        }
        return d3;
    }

    public static void main(String[] stringArray) {
        SensorModel sensorModel = new SensorModel();
        WorldModel worldModel = new WorldModel();
        if (!worldModel.readLandmarksFromFile("map1.txt")) {
            System.exit(1);
        }
        worldModel.printLandmarkList();
        Measurement[] measurementArray = worldModel.getMeasurements(1.0, 9.0, -2.0, sensorModel);
        if (measurementArray != null) {
            for (int i = 0; i < measurementArray.length; ++i) {
                System.out.println(measurementArray[i].m_Id + " " + measurementArray[i].m_Bearing + " " + measurementArray[i].m_Range);
            }
        } else {
            System.out.println("Found no measurements\n");
        }
    }

    private class Landmark {
        public int m_Id;
        public double m_X;
        public double m_Y;
        public double m_Bearing;
        public double m_Range;
        public boolean m_InFOV;
        public boolean m_Visible;
        public double m_AngleWidth;

        private Landmark() {
        }
    }

    public class Measurement {
        public int m_Id;
        public double m_Bearing;
        public double m_Range;
    }
}

