/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

class ExperimentSettings {
    public String m_SourceFilename = "NO_FILE";
    public String m_MapFilename = "map1.txt";
    public String m_TrajFilename = "traj1.txt";
    public String m_OutFilename = "simoutput.txt";
    public Pose m_InitRobotPoseW = new Pose();
    public double m_SimMeasTimeStep = 0.2;
    public boolean m_KnownAssociations = true;
    public boolean m_OutputTruePose = true;
    public double m_WheelRadR_True = 0.1;
    public double m_WheelRadL_True = 0.1;
    public double m_WheelBase_True = 0.35;
    public double m_WheelRadR_Model = this.m_WheelRadR_True;
    public double m_WheelRadL_Model = this.m_WheelRadL_True;
    public double m_WheelBase_Model = this.m_WheelBase_True;
    public boolean m_UseTrueWheelParamsForWheelSpeeds = false;
    public int m_EncoderTicksPerRev = 2048;
    public double m_RobotMaxSpeedV = 1.0;
    public double m_RobotMaxSpeedW = 0.5;
    public double m_RobotMaxAccV = 0.5;
    public double m_RobotMaxAccW = 0.5;
    public double m_RobotMultNoiseStdAccV = 0.0;
    public double m_RobotMultNoiseStdAccW = 0.0;
    public double m_RobotAddNoiseStdAccV = 0.0;
    public double m_RobotAddNoiseStdAccW = 0.0;
    public double m_CtrlMaxSpeedV = 0.5;
    public double m_CtrlMaxSpeedW = 0.5;
    public double m_CtrlGainTrans = 1.0;
    public double m_CtrlGainRot = 1.0;
    public double m_CtrlSpeedRedAngFactor = 0.3490658503988659;
    public Pose m_SensorPoseR = new Pose();
    public double m_SensorNoiseStdBearing = Math.PI / 360;
    public double m_SensorNoiseStdRange = 0.01;
    public double m_SensorBiasBearing = 0.0;
    public double m_SensorBiasRange = 0.0;
    public double m_SensorAngFOV = Math.PI * 2;
    public double m_SensorMaxRange = 100.0;
    public double m_LandmarkDiameter = 0.1;
    public boolean m_ReduceRangeByLandmarkRadius = false;

    public void print() {
        System.out.println("====================== Settings ======================");
        System.out.println("m_MapFilename=\"" + this.m_MapFilename + "\"");
        System.out.println("m_TrajFilename=\"" + this.m_TrajFilename + "\"");
        System.out.println("m_OutFilename=\"" + this.m_OutFilename + "\"");
        System.out.print("m_InitRobotPoseW: ");
        this.m_InitRobotPoseW.print();
        System.out.println("m_SimMeasTimeStep=" + this.m_SimMeasTimeStep + "s");
        System.out.println("m_KnownAssociations=" + this.m_KnownAssociations);
        System.out.println("m_OutputTruePose=" + this.m_OutputTruePose);
        System.out.println("m_WheelRadR_True=" + this.m_WheelRadR_True + "m");
        System.out.println("m_WheelRadL_True=" + this.m_WheelRadL_True + "m");
        System.out.println("m_WheelBase_True=" + this.m_WheelBase_True + "m");
        System.out.println("m_WheelRadR_Model=" + this.m_WheelRadR_Model + "m");
        System.out.println("m_WheelRadL_Model=" + this.m_WheelRadL_Model + "m");
        System.out.println("m_WheelBase_Model=" + this.m_WheelBase_Model + "m");
        System.out.println("m_UseTrueWheelParamsForWheelSpeeds=" + this.m_UseTrueWheelParamsForWheelSpeeds);
        System.out.println("m_EncoderTicksPerRev=" + this.m_EncoderTicksPerRev);
        System.out.println("m_RobotMaxSpeedV=" + this.m_RobotMaxSpeedV + "m/s");
        System.out.println("m_RobotMaxSpeedW=" + this.m_RobotMaxSpeedW + "rad/s");
        System.out.println("m_RobotMaxAccV=" + this.m_RobotMaxAccV + "m/s/s");
        System.out.println("m_RobotMaxAccW=" + this.m_RobotMaxAccW + "rad/s/s");
        System.out.println("m_RobotMultNoiseStdAccV=" + this.m_RobotMultNoiseStdAccV);
        System.out.println("m_RobotMultNoiseStdAccW=" + this.m_RobotMultNoiseStdAccW);
        System.out.println("m_RobotAddNoiseStdAccV=" + this.m_RobotAddNoiseStdAccV + "m/s");
        System.out.println("m_RobotAddNoiseStdAccW=" + this.m_RobotAddNoiseStdAccW + "rad/s");
        System.out.println("m_CtrlMaxSpeedV=" + this.m_CtrlMaxSpeedV + "m/s");
        System.out.println("m_CtrlMaxSpeedW=" + this.m_CtrlMaxSpeedW + "rad/s");
        System.out.println("m_CtrlSpeedRedAngFactor=" + this.m_CtrlSpeedRedAngFactor + "rad");
        System.out.println("m_CtrlGainTrans=" + this.m_CtrlGainTrans + "(m/s)/(m)");
        System.out.println("m_CtrlGainRot=" + this.m_CtrlGainRot + "(rad/s)/(rad)");
        System.out.print("m_SensorPoseR: ");
        this.m_SensorPoseR.print();
        System.out.println("m_SensorNoiseStdBearing=" + this.m_SensorNoiseStdBearing + "rad");
        System.out.println("m_SensorNoiseStdRange=" + this.m_SensorNoiseStdRange + "m");
        System.out.println("m_SensorBiasBearing=" + this.m_SensorBiasBearing + "rad");
        System.out.println("m_SensorBiasRange=" + this.m_SensorBiasRange + "m");
        System.out.println("m_SensorAngFOV=" + this.m_SensorAngFOV + "rad");
        System.out.println("m_SensorMaxRange=" + this.m_SensorMaxRange + "m");
        System.out.println("m_LandmarkDiameter=" + this.m_LandmarkDiameter + "m");
        System.out.println("m_ReduceRangeByLandmarkRadius=" + this.m_ReduceRangeByLandmarkRadius);
        System.out.println("====================== End ======================");
    }

    public boolean readFromFile(String string) {
        try {
            String string2;
            File file = new File(string);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                Object object;
                if ((string2 = string2.trim()).length() == 0 || string2.charAt(0) == '#') continue;
                String[] stringArray = string2.split(" ");
                String string3 = stringArray[0].trim();
                boolean bl = true;
                if (string3.equals("OUTFILENAME")) {
                    object = Utils.getStringArgument(stringArray);
                    if (object == null) continue;
                    this.m_OutFilename = object;
                    continue;
                }
                if (string3.equals("MAPFILENAME")) {
                    object = Utils.getStringArgument(stringArray);
                    if (object == null) continue;
                    this.m_MapFilename = object;
                    continue;
                }
                if (string3.equals("TRAJFILENAME")) {
                    object = Utils.getStringArgument(stringArray);
                    if (object == null) continue;
                    this.m_TrajFilename = object;
                    continue;
                }
                if (string3.equals("SIM_MEAS_TIMESTEP")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_SimMeasTimeStep = (double)object[0];
                    continue;
                }
                if (string3.equals("KNOWN_ASSOCIATIONS")) {
                    object = Utils.getIntArguments(stringArray, 1);
                    if (object != null && object[0] != false) {
                        this.m_KnownAssociations = true;
                        continue;
                    }
                    this.m_KnownAssociations = false;
                    continue;
                }
                if (string3.equals("OUTPUT_TRUEPOSE")) {
                    object = Utils.getIntArguments(stringArray, 1);
                    if (object != null && object[0] != false) {
                        this.m_OutputTruePose = true;
                        continue;
                    }
                    this.m_OutputTruePose = false;
                    continue;
                }
                if (string3.equals("INITIAL_ROBOTPOSE")) {
                    object = Utils.getDoubleArguments(stringArray, 3);
                    if (object == null) continue;
                    this.m_InitRobotPoseW.setPose((double)object[0], (double)object[1], (double)object[2]);
                    continue;
                }
                if (string3.equals("WHEEL_RADIUS_R_TRUE")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_WheelRadR_True = (double)object[0];
                    continue;
                }
                if (string3.equals("WHEEL_RADIUS_L_TRUE")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_WheelRadL_True = (double)object[0];
                    continue;
                }
                if (string3.equals("WHEEL_BASE_TRUE")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_WheelBase_True = (double)object[0];
                    continue;
                }
                if (string3.equals("WHEEL_RADIUS_R_MODEL")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_WheelRadR_Model = (double)object[0];
                    continue;
                }
                if (string3.equals("WHEEL_RADIUS_L_MODEL")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_WheelRadL_Model = (double)object[0];
                    continue;
                }
                if (string3.equals("WHEEL_BASE_MODEL")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_WheelBase_Model = (double)object[0];
                    continue;
                }
                if (string3.equals("USE_TRUE_WHEEL_PARAMS_FOR_WHEEL_SPEEDS")) {
                    object = Utils.getIntArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_UseTrueWheelParamsForWheelSpeeds = object[0] != false;
                    continue;
                }
                if (string3.equals("ENCODER_TICK_PER_REV")) {
                    object = Utils.getIntArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_EncoderTicksPerRev = (int)object[0];
                    continue;
                }
                if (string3.equals("ROBOT_MAX_SPEED_V")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_RobotMaxSpeedV = (double)object[0];
                    continue;
                }
                if (string3.equals("ROBOT_MAX_SPEED_W")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_RobotMaxSpeedW = (double)object[0];
                    continue;
                }
                if (string3.equals("ROBOT_MAX_ACC_V")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_RobotMaxAccV = (double)object[0];
                    continue;
                }
                if (string3.equals("ROBOT_MAX_ACC_W")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_RobotMaxAccW = (double)object[0];
                    continue;
                }
                if (string3.equals("ROBOT_ACC_NOISESTD_ADD_V")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_RobotAddNoiseStdAccV = (double)object[0];
                    continue;
                }
                if (string3.equals("ROBOT_ACC_NOISESTD_ADD_W")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_RobotAddNoiseStdAccW = (double)object[0];
                    continue;
                }
                if (string3.equals("ROBOT_ACC_NOISESTD_MULT_V")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_RobotMultNoiseStdAccV = (double)object[0];
                    continue;
                }
                if (string3.equals("ROBOT_ACC_NOISESTD_MULT_W")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_RobotMultNoiseStdAccW = (double)object[0];
                    continue;
                }
                if (string3.equals("CTRL_MAX_SPEED_V")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_CtrlMaxSpeedV = (double)object[0];
                    continue;
                }
                if (string3.equals("CTRL_MAX_SPEED_W")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_CtrlMaxSpeedW = (double)object[0];
                    continue;
                }
                if (string3.equals("CTRL_GAIN_TRANS")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_CtrlGainTrans = (double)object[0];
                    continue;
                }
                if (string3.equals("CTRL_GAIN_ROT")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_CtrlGainRot = (double)object[0];
                    continue;
                }
                if (string3.equals("CTRL_SPEEDRED_ANGFACTOR")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_CtrlSpeedRedAngFactor = (double)object[0];
                    continue;
                }
                if (string3.equals("SENSOR_POSE")) {
                    object = Utils.getDoubleArguments(stringArray, 3);
                    if (object == null) continue;
                    this.m_SensorPoseR.setPose((double)object[0], (double)object[1], (double)object[2]);
                    continue;
                }
                if (string3.equals("SENSOR_NOISESTD_BEARING")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_SensorNoiseStdBearing = (double)object[0];
                    continue;
                }
                if (string3.equals("SENSOR_NOISESTD_RANGE")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_SensorNoiseStdRange = (double)object[0];
                    continue;
                }
                if (string3.equals("SENSOR_BIAS_BEARING")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_SensorBiasBearing = (double)object[0];
                    continue;
                }
                if (string3.equals("SENSOR_BIAS_RANGE")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_SensorBiasRange = (double)object[0];
                    continue;
                }
                if (string3.equals("SENSOR_ANG_FOV")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_SensorAngFOV = (double)object[0];
                    continue;
                }
                if (string3.equals("SENSOR_MAX_RANGE")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_SensorMaxRange = (double)object[0];
                    continue;
                }
                if (string3.equals("LANDMARK_DIAMETER")) {
                    object = Utils.getDoubleArguments(stringArray, 1);
                    if (object == null) continue;
                    this.m_LandmarkDiameter = (double)object[0];
                    continue;
                }
                if (!string3.equals("REDUCE_RANGE_MEAS_BY_LANDMARK_RADIUS") || (object = (Object)Utils.getIntArguments(stringArray, 1)) == null) continue;
                this.m_ReduceRangeByLandmarkRadius = object[0] != false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void main(String[] stringArray) {
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            if (n < stringArray.length - 1 && stringArray[n].equals("-f")) {
                string = stringArray[n + 1];
                n += 2;
                continue;
            }
            System.out.println("Command line args: -f filename");
            System.exit(1);
        }
        if (string.equals("")) {
            System.err.println("You need to specify a filename with the -f option\n");
            System.exit(1);
        }
        ExperimentSettings experimentSettings = new ExperimentSettings();
        experimentSettings.readFromFile(string);
        experimentSettings.print();
    }
}

