/*
 * Decompiled with CFR 0.152.
 */
public class MotionCtrl {
    private DiffDriveRobotModel m_Robot;
    private double m_MaxV = 0.5;
    private double m_MaxW = 0.5;
    private double m_SpeedRedAngFactor = 0.3490658503988659;
    private double m_GainRotPerAngErr = 1.0;
    private double m_GainTransPerDistErr = 1.0;

    public MotionCtrl(DiffDriveRobotModel diffDriveRobotModel) {
        this.m_Robot = diffDriveRobotModel;
    }

    public void setMaxSpeeds(double d, double d2) {
        this.m_MaxV = d;
        this.m_MaxW = d2;
    }

    public void setCtrlGainTrans(double d) {
        this.m_GainTransPerDistErr = d;
    }

    public void setCtrlGainRot(double d) {
        this.m_GainRotPerAngErr = d;
    }

    public void setSpeedReductionAngleFactor(double d) {
        this.m_SpeedRedAngFactor = d;
    }

    public boolean ctrlGotoXY(double d, double d2, double d3, boolean bl) {
        double d4;
        double d5;
        Object object;
        if (this.m_Robot == null) {
            System.err.println("MotionCtrl: robot is null!!!\n");
            return false;
        }
        if (bl) {
            object = this.m_Robot.getOdometry();
            d5 = Math.hypot(d2 - ((DiffDriveRobotModel.Odometry)object).m_Pose.getY(), d - ((DiffDriveRobotModel.Odometry)object).m_Pose.getX());
            double d6 = Math.atan2(d2 - ((DiffDriveRobotModel.Odometry)object).m_Pose.getY(), d - ((DiffDriveRobotModel.Odometry)object).m_Pose.getX());
            d4 = this.angleDiffRad(d6, ((DiffDriveRobotModel.Odometry)object).m_Pose.getTheta());
        } else {
            object = this.m_Robot.getTruePose();
            d5 = Math.hypot(d2 - ((Pose)object).getY(), d - ((Pose)object).getX());
            double d7 = Math.atan2(d2 - ((Pose)object).getY(), d - ((Pose)object).getX());
            d4 = this.angleDiffRad(d7, ((Pose)object).getTheta());
        }
        double d8 = this.m_GainRotPerAngErr * d4;
        double d9 = -0.5 / Math.pow(this.m_SpeedRedAngFactor, 2.0);
        double d10 = this.m_GainTransPerDistErr * d5 * Math.exp(d9 * d4 * d4);
        if (d10 > this.m_MaxV) {
            d10 = this.m_MaxV;
        }
        if (d8 > this.m_MaxW) {
            d8 = this.m_MaxW;
        } else if (d8 < -this.m_MaxW) {
            d8 = -this.m_MaxW;
        }
        this.m_Robot.setRefSpeedsAndUpdate(d10, d8);
        return d5 < d3;
    }

    public boolean ctrlTurnTo(double d, double d2, boolean bl) {
        double d3;
        if (this.m_Robot == null) {
            System.err.println("MotionCtrl: robot is null!!!\n");
            return false;
        }
        if (bl) {
            DiffDriveRobotModel.Odometry odometry = this.m_Robot.getOdometry();
            d3 = this.angleDiffRad(d, odometry.m_Pose.getTheta());
        } else {
            d3 = this.angleDiffRad(d, this.m_Robot.getTruePose().getTheta());
        }
        double d4 = 1.0 * d3;
        if (d4 > this.m_MaxW) {
            d4 = this.m_MaxW;
        } else if (d4 < -this.m_MaxW) {
            d4 = -this.m_MaxW;
        }
        this.m_Robot.setRefSpeedsAndUpdate(0.0, d4);
        return Math.abs(d3) < d2;
    }

    private double angleDiffRad(double d, double d2) {
        double d3;
        for (d3 = d - d2; d3 <= -Math.PI; d3 += Math.PI * 2) {
        }
        while (d3 > Math.PI) {
            d3 -= Math.PI * 2;
        }
        return d3;
    }

    public static void main(String[] stringArray) {
        DiffDriveRobotModel diffDriveRobotModel = new DiffDriveRobotModel();
        diffDriveRobotModel.configKinematics(0.101, 0.1, 0.35, 0.1, 0.1, 0.35);
        MotionCtrl motionCtrl = new MotionCtrl(diffDriveRobotModel);
        double[] dArray = new double[]{5.0, 5.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 5.0, 5.0, 0.0};
        System.out.println("" + diffDriveRobotModel.getTime() + " " + diffDriveRobotModel.getOdometry().m_Pose.getX() + " " + diffDriveRobotModel.getOdometry().m_Pose.getY() + " " + diffDriveRobotModel.getOdometry().m_Pose.getTheta() + " " + diffDriveRobotModel.getOdometry().m_EncR + " " + diffDriveRobotModel.getOdometry().m_EncL + " " + diffDriveRobotModel.getTruePose().getX() + " " + diffDriveRobotModel.getTruePose().getY() + " " + diffDriveRobotModel.getTruePose().getTheta());
        for (int i = 0; i < 1; ++i) {
            System.err.println("Heading for x=" + dArray[i] + " y=" + dArray2[i]);
            while (!motionCtrl.ctrlGotoXY(dArray[i], dArray2[i], 0.5, false)) {
                System.out.println("" + diffDriveRobotModel.getTime() + " " + diffDriveRobotModel.getOdometry().m_Pose.getX() + " " + diffDriveRobotModel.getOdometry().m_Pose.getY() + " " + diffDriveRobotModel.getOdometry().m_Pose.getTheta() + " " + diffDriveRobotModel.getOdometry().m_EncR + " " + diffDriveRobotModel.getOdometry().m_EncL + " " + diffDriveRobotModel.getTruePose().getX() + " " + diffDriveRobotModel.getTruePose().getY() + " " + diffDriveRobotModel.getTruePose().getTheta());
            }
        }
    }
}

