/*
 * Decompiled with CFR 0.152.
 */
public class Pose {
    private double m_X;
    private double m_Y;
    private double m_Theta;

    public void setX(double d) {
        this.m_X = d;
    }

    public void setY(double d) {
        this.m_Y = d;
    }

    public void setPose(double d, double d2, double d3) {
        this.setX(d);
        this.setY(d2);
        this.setTheta(d3);
    }

    public void setPose(Pose pose) {
        this.setPose(pose.getX(), pose.getY(), pose.getTheta());
    }

    public void setTheta(double d) {
        this.m_Theta = d;
    }

    public double getX() {
        return this.m_X;
    }

    public double getY() {
        return this.m_Y;
    }

    public double getTheta() {
        return this.m_Theta;
    }

    public Pose() {
        this.setX(0.0);
        this.setY(0.0);
        this.setTheta(0.0);
    }

    public Pose(Pose pose) {
        this.setPose(pose.getX(), pose.getY(), pose.getTheta());
    }

    public Pose(double d, double d2, double d3) {
        this.setPose(d, d2, d3);
    }

    public void print() {
        System.out.println("x=" + this.m_X + " y=" + this.m_Y + " theta=" + this.m_Theta);
    }

    public Pose compound(Pose pose) {
        Pose pose2 = new Pose();
        pose2.setX(pose.getX() * Math.cos(this.getTheta()) - pose.getY() * Math.sin(this.getTheta()) + this.getX());
        pose2.setY(pose.getX() * Math.sin(this.getTheta()) + pose.getY() * Math.cos(this.getTheta()) + this.getY());
        pose2.setTheta(this.getTheta() + pose.getTheta());
        while (pose2.getTheta() > Math.PI) {
            pose2.setTheta(pose2.getTheta() - Math.PI * 2);
        }
        while (pose2.getTheta() < -Math.PI) {
            pose2.setTheta(pose2.getTheta() + Math.PI * 2);
        }
        return pose2;
    }

    public Pose invCompound() {
        Pose pose = new Pose();
        pose.setX(-this.getX() * Math.cos(this.getTheta()) - this.getY() * Math.sin(this.getTheta()));
        pose.setY(this.getX() * Math.sin(this.getTheta()) + -this.getY() * Math.cos(this.getTheta()));
        pose.setTheta(-this.getTheta());
        return pose;
    }

    public static void main(String[] stringArray) {
        Pose pose = new Pose(1.0, 2.0, 1.5707963267948966);
        System.out.print("p1: ");
        pose.print();
        Pose pose2 = new Pose(2.0, 3.0, 0.0);
        System.out.print("p1: ");
        pose2.print();
        System.out.print("inv(p1): ");
        pose.invCompound().print();
        System.out.print("inv(p2): ");
        pose2.invCompound().print();
        System.out.print("p1+p2: ");
        pose.compound(pose2).print();
    }
}

