% plot r-sigma uncertainty region for a P covariance matrix.
% Jose-1999
%
% X0 - mean value (2-vector)
% P  - covariance matrix (2x2-matrix)
% r  - circle's radius in space X2 
%
function xxx=uncEllipse(X0,P,veces,r)

if (nargin < 4)
  r = 1;
end

R = chol(P)';  % R*R'= P, X = R*X2
aaa = [0:veces]*2*pi/veces ;			% sample angles
xxx = [ r*cos(aaa) ; r*sin(aaa) ] ; % polar to x2,y2
xxx = R*xxx ;	 %x2,y2 to x,y
xxx(1,:) = X0(1)+xxx(1,:);	% reference to center X0
xxx(2,:) = X0(2)+xxx(2,:);
return;
