#include "mex.h"

#define F  prhs[0]
#define DX prhs[1]

#define DF plhs[0]

void cen_diff_pbc(double* f, double* df,  
		  double dx, int n)
{
    int i;

    df[0] = (f[1]-f[n-1])/(2*dx);
    for(i = 1; i<n-1; i++)
	df[i] = (f[i+1]-f[i-1])/(2*dx);

    df[n-1] = (f[0]- f[n-2])/(2*dx);
}

void mexFunction(int nlhs,       mxArray *plhs[],
		 int nrhs, const mxArray *prhs[] )
{
    if (nlhs != 1)
	mexErrMsgTxt("D0 (mex): Must have one output argument.");
    else if (nrhs != 2)
	mexErrMsgTxt("D0 (mex): Must have two input arguments. ");
    else if ( mxGetN(F) != 1 )
	mexErrMsgTxt("D0 (mex): F must be a column vector.");
    else if ( (mxGetN(DX) != 1) || (mxGetM(DX) != 1) )
	mexErrMsgTxt("D0 (mex): DX must be scalar.");

    int n = mxGetM(F);
    DF = mxCreateDoubleMatrix(n, 1, mxREAL);

    cen_diff_pbc(mxGetPr(F), mxGetPr(DF), *mxGetPr(DX),n);

    return;
}
