tic
clear all, close all

% Paramters
func = inline('[x(1)+1 x(2)-1]','t','x');
t_0 = 0;
t_end = 3.02157;
h = 0.0001;
u_0 = [0 0];

Nt = round((t_end-t_0)/h)+1; % make sure we hit t_end
h = (t_end-t_0)/(Nt-1);

% IC
t = t_0;
u = u_0;

% Time-stepping
T = t;
U = u;
for i = 2:Nt
  
  % Explicit Euler
  u = u + h*func(t,u);
  t = t+h;
  
  % Accumulate data
  T = [T ; t];
  U = [U ; u];
end
toc