tic
clear all, close all

% Paramters
func = @(t,x) [x(1)+1 x(2)-1];
t_0 = 0;
t_end = 3.02157;
h = 0.0001;
u_0 = [0 0];

Nt = round((t_end-t_0)/h)+1;
h = (t_end-t_0)/(Nt-1);

% IC
t = t_0;
u = u_0;

% Pre-allocate storage
T = zeros(Nt,1);
U = zeros(Nt,length(u));

% Time-stepping
T(1) = t;
U(1,:) = u_0;
for i = 2:Nt
  
  % Explicit Euler
  u = u + h*func(t,u);
  t = t + h; 

  % Accumulate data
  T(i)   = t;
  U(i,:) = u;
end
toc