clear

N = 10000; % length
M = 10000; % reps
func = @(t) sin(t);

t = linspace(0,2*pi,N+1)';
t = t(1:end-1);
f = func(t);
h = t(2)-t(1);

s = 'df3';

tic
switch(s)

 case 'df1'
  % Attempt 1: Full loop
  %   Note: Some matlab versions may accelerate this code.
  %         To experiment with this, turn of the JIT compiler, 
  %         by typing 'feature accel off'
  for k = 1:M

    df = zeros(size(f));
    df(1) = (f(2)-f(N));
    for i = 2:N-1
      df(i) = (f(i+1)-f(i-1))/(2*h);
    end
    df(N) = (f(1)-f(N-1));

  end

 case 'df2'

  % Attempt 2: Vectorized 1
  for k = 1:M

    df = zeros(size(f));
    df(1) = (f(2)-f(N));
    df(2:N-1) = f(3:N) - f(1:N-2);
    df(N) = (f(1)-f(N-1));
    df = df/(2*h);
    
  end

 case 'df3'

  % Attempt 3: Vectorized 2, Precompute index vectors
  ip = int32([2:N 1]);
  im = int32([N 1:N-1]);
  for k = 1:M
    df = (f(ip) - f(im))/(2*h);
  end

 case 'df4'
  % Attempt 4: Vectorized 3, wrap f
  for k = 1:M

    fp = [f(2:N); f(1)];
    fm = [f(N); f(1:N-1)];
    df = (fp - fm)/(2*h);

  end

 case 'df5'
  % Attempt 5: Vectorized 4, wrap index
  for k = 1:M
    
    fp = f([2:N 1]);
    fm = f([N 1:N-1]);
    df = (fp - fm)/(2*h);
    
  end

 case 'df6'
  % Attempt 6: Compiled C-code, using the (C-)MEX API. To compile: type
  % 'mex D0_mex.c' You must have a C-compiler installed to try
  % this. Run 'mex setup' the first time. Look at the source code!
  for k=1:M
    
    df = D0_mex(f,h);
  
  end
  
end
toc
