function [T U] = euler(func, Tspan, h, u_0)
% example:
% f = @(t,x) [x(1)+1 x(2)-1];
% [T U] = euler(f, [0 2.3], 0.001, [0 0])

% steps
Nt = ceil((Tspan(2)-Tspan(1))/h)+1;
h = (Tspan(2)-Tspan(1))/(Nt-1);

% IC
t = Tspan(1);
u = u_0;

% Pre-allocate storage
T = zeros(Nt,1);
U = zeros(Nt,length(u));

% Time-stepping
T(1) = t;
U(1,:) = u;
for i = 2:Nt
  
  % Explicit Euler
  u = u + h*func(t,u);
  t = t + h; 

  % Accumulate data
  T(i)   = t;
  U(i,:) = u;
end
