clear all, close all

% Evaluate:
% f(t) = 1, if t < 1
% f(t) = 2, if t >= 1 and t < 2
% f(t) = 0, if t >= 2

N = 2000;
M = 10000; % repetitions (to get measurable times)
t = linspace(0,3,N);

tic
for k = 1:M

  % Attempt 1: loop
  f = zeros(N,1);
  for i = 1:N
    if t(i) < 1
      f(i) = 1;
    elseif t(i) >= 1 && t(i) < 2
      f(i) = 2;
    end
  end

end, toc

tic
for k = 1:M

  % Attempt 2: Array indexing
  f = zeros(N,1);
  f( find(t < 1) ) = 1;
  f( find(t >= 1 & t < 2) ) = 2;

end, toc

tic
for k = 1:M

  % Attempt 3: Logical subscripting
  f = zeros(N,1);
  f( t < 1 ) = 1;
  f( t >= 1 & t < 2) = 2;

end, toc

tic
for k = 1:M

  % Attempt 4: Conversion from logical to double
  f = ( t < 1 ) + 2*( t >= 1 & t < 2 ); 

end, toc
