clear all
N = 1e5;

s = 'sp1';
tic
  switch(s)
    
   case 'sp1'
    % Attempt 1: 
    % Allocate empty matrix, iterate by row
    A = sparse(N,N);
    A(1,1) = -2;
    A(1,2) = 1;
    for i = 2:N-1
      A(i,i-1) = 1;
      A(i,i) = -2;
      A(i,i+1) = 1;
    end
    A(N,N-1) = 1;
    A(N,N) = -2;

   case 'sp2'
    % Attempt 2:
    % Allocate empty matrix with space reserved
    % Iterate by column
    A = sparse([],[],[],N,N,3*N);
    A(1,1) = -2; 
    A(2,1) = 1; 
    for i = 2:N-1
      A(i-1,i) = 1;
      A(i,i) = -2; 
      A(i+1,i) = 1;
    end
    A(N-1,N) = 1;
    A(N,N) = -2;

   case 'sp3'
    % Attempt 3:
    % Create index and nz-data vectors,
    % then make sparse matrix.
    I = zeros(3*N-2,1);
    J = I;
    X = I;
    I(1) = 1; J(1) = 1; X(1) = -2;               % B(1  ,1) = -2
    I(2) = 2; J(2) = 1; X(2) =  1;               % B(2  ,1) =  1
    k = 3;
    for i = 2:N-1
      I(k)   = i-1; J(k)   = i; X(k)   =  1;     % B(i-1,i) =  1
      I(k+1) = i;   J(k+1) = i; X(k+1) = -2;     % B(i  ,i) = -2
      I(k+2) = i+1; J(k+2) = i; X(k+2) =  1;     % B(i+1,i) =  1
      k = k+3;
    end
    I(end-1) = N-1; J(end-1) = N; X(end-1) =  1; % B(N-1,N) =  1
    I(end  ) = N;   J(end  ) = N; X(end  ) = -2; % B(N-1,N) = -2

    A = sparse(I,J,X);

   case 'sp4'
    % Attempt 4:
    % Make tridiagonal matrix "directly"
    e = ones(N,1);
    A = spdiags([e -2*e e],[-1 0 1],N,N);
  end
toc
