% TM dielectric scattering circular cylinder (exact)
% ui = sum( ci(n) J(n,ki*r) exp(i*n*fi)
% ue = sum( ce(n) H2(n,ki*r) exp(i*n*fi)
% Equations
%   ci(m) J(m,kiR) - ce(m) H2(m,keR) = J(m,keR)*i^m
%   ci(m) ki (J(m-1,kiR) - m/kiR J(m,kiR)) - ce(m) ke (H2(m-1,keR) - m/keR H2(m,keR) = 
%    = i^m ke/2 (J(m-1,keR) - J(m+1,keR))
R   = 3;
Rex = 10;
% wave numbers
ke  = 1;
ki  = 2;

% polar evaluation grid
nfi = 30;
nr  = 30;
fi  = (0:nfi-1)*pi/(nfi-1);
ni  = round( ki*R/(ke*(Rex-R)+ki*R)*nr);
r   = [linspace(0,0.99*R,ni),...
	   linspace(1.01*R,Rex,nr-ni)]';
nr  = length(r);
z   = r*exp(i*fi);
x   = real(z); y = imag(z);

indz = find(r < R);

kir  = ki*r;
kiR  = ki*R;
ker  = ke*r;
keR  = ke*R;

ui  = zeros(nr,nfi);
ue  = ui;
for n = -10:10
% find coeff
% Equations
%   ci(m) J(m,kiR) - ce(m) H2(m,keR) = J(m,keR)*i^m
%   ci(m) ki (J(m-1,kiR) - m/kiR J(m,kiR)) - ce(m) ke (H2(m-1,keR) - m/keR H2(m,keR)) = 
%    = i^m ke/2 (J(m-1,keR) - J(m+1,keR))
	jnkiR  = besselj(n,kiR);
	h2nkeR = besselh(n,2,keR);
	A = [jnkiR                             , -h2nkeR;...
    	ki*(besselj(n-1,kiR) - n/kiR*jnkiR), -ke*(besselh(n-1,2,keR) - n/keR*h2nkeR)];
	rhs = (i^n)*[besselj(n,keR);ke/2*(besselj(n-1,keR)-besselj(n+1,keR))];
	tmp = A\rhs;
	ci  = tmp(1); ce = tmp(2);
% sum up exterior and interior scattered fields
	einfi = exp(i*n*fi);
	ui = ui + ci*besselj(n,kir)*einfi;
	ue = ue + ce*besselh(n,2,ker)*einfi;
end;

% scattered field
u = ue;
u(indz,:) = ui(indz,:);

% total field
utot = ue + exp(i*ker*cos(fi));
utot(indz,:) = ui(indz,:);

% plot sources vs. fi
figure(3)
plot([fi,fi+pi],abs([ u(ni,:),fliplr(u(ni,:)) ]));
pause

% show scattered field
figure(1);clf;surf(x,y,real(u)); 
view(2),axis([-Rex Rex 0 Rex]), axis equal, shading interp

% show total field
figure(2); clf, surf(x,y,real(utot)); 
view(2); axis([-Rex Rex 0 Rex]), axis equal, shading interp

pause


% animate total field
figure(3)
coef = exp(i*linspace(0,2*pi,30));
kk = 1;
while kk ==1,
	for c = coef,
		surf(x,y,real(c*utot));
		caxis([-2 2])
		axis([-Rex Rex 0 Rex]), 
		axis equal
		shading interp
		drawnow
	end
end
