function E = field(z,zprime,gamma,sigma,k)
% computes the field at the points r(1:np) (2D: r(p) = x(p) + i y(p))
% form the 
% single layer  sigma(1:ns-1) and 
% double layer  gamma(1:ns-1) 
% on the curve  rprime(1:ns).
% the Greens function is for the Helmholtz equation
% (delsq + k2)u = ...
% and all of R2 i.e. H2,0(k|r - rprime|)
%r
[m,n]  = size(z);
ns     = length(zprime);
np     = m*n; 
z      = z(:);                                    % make columns
gamma  = gamma(:);
sigma  = sigma(:);
zprime = zprime(:);  

delta  = diff(zprime);                           % facets             
zphalf = 0.5*(zprime(1:ns-1) + zprime(2:ns));    % midpoints
d      = z*ones(1,ns-1) - ones(np,1)*(zphalf.'); % all distance vectors
			                                     % at once
G      = Greenfunc(k,d);                         % single layer Green
Gn     = k*Greenfuncder(k,d).*(d./abs(d));       % gradient of double layer Green
gam    = gamma.*delta;                           % trick ...
sig    = sigma.*abs(delta);                      % length element
E      = reshape(G*sig - imag(Gn*conj(gam)),m,n);% scalar product with element normal

