% Method of Moments, TM wave scattered on dielectric cylinder
% One-point quadrature ... too inaccurate, really !
% wave numbers
clear
clf

ki = 2;
ke = 1;

% Geometry defined by facet vertices z(1:n)
% test : a circle
n  = 100;
R  = 3;
fi = (0:n-1)/n*2*pi;
z  = R*exp(i*fi);

% --- z, ki, ke is only input to the rest of the program
gamma = 0.5772156649;

% collocation at midpoints
zm = 0.5*(z(1:n) + [z(2:n),z(1)]);
% point-to-point vectors
zmtozm = ones(n,1)*zm - (zm.')*ones(1,n);
% distances - we'll replace the diagonal later, just to avoid besselh(0)
d = abs(zmtozm) + eye(n);

% panels:
dz = diff([z,z(1)]);
% lengths
ph = abs(dz);
2*pi/ke/ph(1),
2*pi/ki/ph(1),
% unit normals - outward, points numbered anti-clockwise !
pn = -i*dz./ph;

% incoming wave is exp(i*ke*x)
uinc = exp(i*ke*real(zm));

% the unknowns are panel lengths * sources - 
% no h-scaling in matrix !

% construct matrix
%  Ge  He
%  Gi  Hi

% Non-diagonal part of G
% Greens function is 1/(4i) besselh(kr)
o4i = -0.25*i;
Ge = o4i*besselh(0,2,ke*d ); 
Gi = o4i*besselh(0,2,ki*d );

% diagonal

% from maple: 
% 2*int(convert(series(HankelH2(0,x),x=0,2),polynom),x=0..h/2);
I   = i;
Pi  = pi;
% first Ge
h = ke*ph;
dGe = o4i*diag(h.*(Pi+2*I*log(4./h)+2*I-2*I*gamma)/Pi/ke./ph);
% replace diagonal ...
Ge  = Ge - diag(diag(Ge)) + dGe;
% ... and then Gi
h   = ki*ph;
dGi = o4i*diag(h.*(Pi+2*I*log(4./h)+2*I-2*I*gamma)/Pi/ki./ph);
Gi  = Gi - diag(diag(Gi)) + dGi;

% H 
% the cosine matrix ...
cosmat = real((zmtozm./d).*(ones(n,1)*conj(pn)));
% non-diagonal part
He  = o4i*ke*besselh(1,2,ke*d ).*cosmat;
Hi  = o4i*ki*besselh(1,2,ki*d ).*cosmat;
% replace diagonal
He  = He - diag(diag(He)) + 1/2*eye(n)/ph(1);
Hi  = Hi - diag(diag(Hi)) - 1/2*eye(n)/ph(1);

% solve
tmp = [-Ge, -He; Gi, Hi] \ [-uinc.';zeros(n,1)];
u = tmp(1:n)./ph';
v = tmp(n+1:2*n)./ph';

% plot
figure(1);
plot(fi + 0.5*(fi(2)-fi(1)),abs(v),'k');
% plot(fi, abs(v),'b');
pause
% ... and visualize on polar evaluation grid
Rex = 10;
nfi = 30;
nr  = 30;
fi  = (0:nfi-1)*pi/(nfi-1);
ni  = round(ki*R/(ke*(Rex-R)+ki*R)*nr);
r   = [linspace(0,0.95*R,ni),...
	   linspace(1.05*R,Rex,nr-ni)]';
nr   = length(r);
zvis = r*exp(i*fi); 
x = real(zvis); y = imag(zvis);
Z    = zvis(:); N = length(Z);

% point-to-point vectors
Ztozm = ones(N,1)*zm - Z*ones(1,n);
% do this in blocks to avoid large matrices
nbl = 30;
nrows = floor(N/nbl);
N - nrows*nbl
for ibl = 1:nbl+1,
	ibl,
   nor = nrows;
   if ibl==nbl+1
	  nor = N - nrows*nbl;
	  if nor == 0
		 break
	  end
   end
   ztoz = Ztozm((ibl-1)*nrows+1:(ibl-1)*nrows+nor,:);
% distances
   d = abs(ztoz);

% G
   Ge = o4i*besselh(0,2,ke*d ); 
   Gi = o4i*besselh(0,2,ki*d );
% H 
% the cosine matrix ...
   cosmat = real((ztoz./d).*(ones(nor,1)*conj(pn)));
% H
   He   = o4i*ke*besselh(1,2,ke*d ).*cosmat;
   Hi   = o4i*ki*besselh(1,2,ki*d ).*cosmat;
   Eext((ibl-1)*nrows+1:(ibl-1)*nrows+nor) = Ge*(u.*ph') + He*(v.*ph');
   Eint((ibl-1)*nrows+1:(ibl-1)*nrows+nor) = -Gi*(u.*ph') - Hi*(v.*ph');
end
size(Eext),
tmp = reshape(Eint,nr,nfi);
hold on; plot([fi,fi+pi],abs([tmp(ni,:),fliplr(tmp(ni,:))]),'b');

figure(2);
subplot(221); surf(x,y,real(reshape(Eext,nr,nfi)));
axis equal; view(2); shading interp, title('Re Ext'); caxis([-2 2]);
subplot(222); surf(x,y,abs(reshape(Eext,nr,nfi)));
axis equal; view(2); shading interp, title('Abs Ext'); caxis([-2 2]);
subplot(223); surf(x,y,real(reshape(Eint,nr,nfi))); 
axis equal; view(2); shading interp, title(' Re Int'); caxis([-2 2]);
subplot(224); surf(x,y,abs(reshape(Eint,nr,nfi))); 
axis equal; view(2); shading interp, title(' Abs Int'); caxis([-2 2]);

figure(3)
Eext = Eext.'; Eint = Eint.';
Einc = exp(i*ke*x); 
Epl  = reshape(Eext + Einc(:),nr,nfi);
indi = find(abs(Z) < R);
tmp = reshape(Eint,nr,nfi);
Epl(indi) = tmp(indi);
surf(x,y,real(Epl)); axis equal; view(2); shading interp
