% TM PEC scattering circular cylinder exact
rect = 1
R   = 1;
Rex = 3;
%k   = 2.404826;
k = 35;
nfi = 300;
fi  = (0:nfi-1)*2*pi/(nfi-1);
nr  = 300;
r   = linspace(R,Rex,nr)';
z   = r*exp(i*fi);
x   = real(z); y = imag(z);
u   = zeros(nr,nfi);
if rect
  [x,y]=meshgrid(linspace(-Rex,Rex,nr),linspace(-Rex,Rex,nr));
  z = x + i*y;
  r = abs(z); fi = angle(z);
  u = zeros(nr,nr);
  indz = find(r < R);
end;
kr  = k*r;
KR  = k*R;

for n = -100:100
	if rect
		u = u + besselj(n,KR)/besselh(n,2,KR)*besselh(n,2,kr).*exp(i*n*fi)*i^n;
	else
		u = u +  besselj(n,KR)/besselh(n,2,KR)*besselh(n,2,kr)*exp(i*n*fi)*i^n;
	end
end;
if rect
	u(indz)=0;
end
figure(1);clf;surf(x,y,real(u)); 
view(2),axis([-Rex Rex -Rex Rex]), axis equal, shading interp
figure(2);clf;
if rect
	surf(x,y,real(u-exp(i*k*x))); 
else
	surf(x,y,real(u-exp(i*kr*cos(fi)))); 
end
 axis equal

view(2);
shading interp

% animate
coef = exp(i*linspace(0,2*pi,30));
kk = 1;
while kk ==1,
	for c = coef,
		figure(2)
		upl = real(u*c);
		if rect
			surf(x,y,real(c*(u-exp(i*k*x))));
		else
			surf(x,y,real(c*(u-exp(i*k*r*cos(fi)))));
		end
		axis([-Rex Rex -Rex Rex]), 
		axis equal
		shading interp
		drawnow
	end
end
