% Method of Moments, TM wave scattered on PEC cylinder
% One-point quadrature ... too inaccurate, really !
% wave numbers
clear
clf

ke = 3;

% Geometry defined by facet vertices z(1:n)
% test : a circle
n  = 100;
R  = 3;
fi = (0:n-1)/n*2*pi;
z  = R*exp(i*fi);

% --- z, ki, ke is only input to the rest of the program
gamma = 0.5772156649;

% collocation at midpoints
zm = 0.5*(z(1:n) + [z(2:n),z(1)]);
% point-to-point vectors
zmtozm = ones(n,1)*zm - (zm.')*ones(1,n);
% distances - we'll replace the diagonal later, just to avoid besselh(0)
d = abs(zmtozm) + eye(n);

% panels:
dz = diff([z,z(1)]);
% lengths
ph = abs(dz);
2*pi/ke/ph(1),
% unit normals - outward, points numbered anti-clockwise !
pn = -i*dz./ph;

% incoming wave is exp(i*ke*x)
uinc = exp(i*ke*real(zm));

% the unknowns are panel lengths * sources - 
% no h-scaling in matrix !

% construct matrix
%  Ge 

% Non-diagonal part of G
% Greens function is 1/(4i) besselh(kr)
o4i = -0.25*i;
Ge = o4i*besselh(0,2,ke*d ); 

% diagonal

% from maple: 
% 2*int(convert(series(HankelH2(0,x),x=0,2),polynom),x=0..h/2);
I   = i;
Pi  = pi;
% first Ge
h = ke*ph;
dGe = o4i*diag(h.*(Pi+2*I*log(4./h)+2*I-2*I*gamma)/Pi/ke./ph);
% replace diagonal ...
Ge  = Ge - diag(diag(Ge)) + dGe;

% solve
tmp = -Ge \ (uinc.');
u = tmp(1:n)./ph';

% plot
figure(1);
plot(fi + 0.5*(fi(2)-fi(1)),abs(u),'k');
% plot(fi, abs(v),'b');
pause
% ... and visualize on polar evaluation grid
Rex = 10;
nfi = 30;
nr  = 30;
fi  = (0:nfi-1)*pi/(nfi-1);
ni  = 5;
r   = [linspace(0,0.95*R,ni),...
	   linspace(1.05*R,Rex,nr-ni)]';
nr   = length(r);
zvis = r*exp(i*fi); 
x = real(zvis); y = imag(zvis);
Z    = zvis(:); N = length(Z);

% point-to-point vectors
Ztozm = ones(N,1)*zm - Z*ones(1,n);
% do this in blocks to avoid large matrices
nbl = 30;
nrows = floor(N/nbl);
N - nrows*nbl
for ibl = 1:nbl+1,
	ibl,
   nor = nrows;
   if ibl==nbl+1
	  nor = N - nrows*nbl;
	  if nor == 0
		 break
	  end
   end
   ztoz = Ztozm((ibl-1)*nrows+1:(ibl-1)*nrows+nor,:);
% distances
   d = abs(ztoz);

% G
   Ge = o4i*besselh(0,2,ke*d ); 
   Eext((ibl-1)*nrows+1:(ibl-1)*nrows+nor) = Ge*(u.*ph');
end

figure(2);
subplot(221); surf(x,y,real(reshape(Eext,nr,nfi)));
axis equal; view(2); shading interp, title('Re Ext'); caxis([-2 2]);
subplot(222); surf(x,y,abs(reshape(Eext,nr,nfi)));
axis equal; view(2); shading interp, title('Abs Ext'); caxis([-2 2]);

figure(3)
Eext = Eext.'; 
Einc = exp(i*ke*x); 
Epl  = reshape(Eext + Einc(:),nr,nfi);
indi = find(abs(Z) < R);
Epl(indi) = 0;
surf(x,y,real(Epl)); axis equal; view(2); shading interp
