% test the field computation
nx = 60;
ny = 90;
np = nx * ny;
x0 = -5; x1 = 5;
y0 =-5; y1 = 5;
x = linspace(x0,x1,nx);
y = linspace(y0,y1,ny);
[X,Y] = meshgrid(x,y);
Z = X + i*Y;
% the curve: a circle
cen = 0.01 + i*0.01;
rad =1;
k = 100;
ns  = 10;
rprim = cen + rad*exp(i*linspace(0,2*pi,ns));
sigma = real(rprim(1:ns-1));
% incoming plane wave
sigma = 0*sigma;
gamma = 0*imag(rprim(1:ns-1));
gamma = exp(i*k*real(rprim(1:ns-1)));
E = field(Z,rprim,gamma,sigma,3);
subplot(131), surf(X,Y,abs(E)); axis equal; shading interp
subplot(132), surf(X,Y,real(E)); axis equal; shading interp
subplot(133), surf(X,Y,imag(E)); axis equal; shading interp
