% This script initilizes the parameters that describe the robot arm

global cube_size cube_mass cube_moment


% generates straight arm
%theta_i = [0 -90 -90 0 0 0]'*pi/180;

% generates default arm
theta_i = [140 250 170 0 330 90]'*pi/180;

% generates zero-angle arm
%theta_i = [0 0 0 0 0 0]'*pi/180;

thetas = [90 -90 180 -90 -60 100]'*pi/180;

% Some PowerCube data:
%
% torques and vels with high gear (size[mm]:torque[Nm]:vel[deg/s])
% 110:134:470, 90:65:470, 70:23:470   p/t90:73/35:149/248, p/t70:35/8:248:356
%
% torques with medium gear (size:torque)
% 110:267:238, 90:129:238, 70:46:238   p/t90:73/35, p/t70:35/8
%
% torques with low gear (size:torque)
% 110:425:149, 90:206:149, 70:73:149   p/t90:73/35, p/t70:35/8
%
% masses:
% 110:5.6, 90:3.2, 70:1.7 p/t90:3.4 p/t70:1.8

% Data for popeye, indexed by joint.
% Cube_size are the sides of the cubes.
% The cube mass assumes uniform mass distribution.
% The end actuator is assumed to be extra heavy, in order to
% compensate for cable mass.

cube_size = [11 11 11 7 7 7]*0.01;
cube_mass = [2.8 2.8 2.8 0.85 0.9 0.5]+0.5; % 0.5 kg added to each
                                            % cube to compensate
                                            % for mass of
                                            % links. This is very
                                            % conservative. 
cube_moment = [134 267 134 23 35 8];
%cube_moment = [267 267 267 23 35 8];  % Alternative configs
%cube_moment = [425 425 425 23 35 8];
link_length=[0.055 0.2 0.045 0.2 0 0.07];
arm_vels = [470 238 470 470 248 356]*pi/180;
%arm_vels = [238 238 238 470 248 356]*pi/180; % Alternative configs
%arm_vels = [149 149 149 470 248 356]*pi/180;

friction_coeff = [0.005 0.005 0.005 0.005 0.005 0.005]'; % Very Ad hoc!

% D-H parameters, derived from dimensions above
d3 = cube_size(2)-cube_size(3)
d4 = sum(link_length([3 4]))+cube_size(4)*2+cube_size(3)/2+cube_size(5)
a2 = link_length(2)+sum(cube_size([2 3]))/2

al_im1 = [0 -90 0 -90 -90 90]'*pi/180;
a_im1 = [0 0 a2 0 0 0]';
d_i = [0 0 -d3 d4 0 0]';

L = [sum(cube_size([1 2]))/2+link_length(1) sum(cube_size([3 4]))/2+link_length(3) sum(cube_size([5 6]))/2+link_length(6)]; 

% positions for midpoints for PowerCubes. 
% pos1 is the part of the cube that is fastened to the previous
% link, pos2 is the part that is fastened to the next link. All
% coordinates are given in the frame for which the cubepart is
% stationary.
% imaginary x-values means that the cube-part does not exist.

pos1 = [0 0 -L(1)-cube_size(1) 1;...
       0 0 0 1;...
       a2 0 -cube_size(3)-d3 1;...
       0 L(2) 0 1;...
       0 0 0 1;...
       i 0 0 1]';

pos2 = [0 0 -L(1) 1;...
       0 0 -cube_size(2) 1;...
       0 0 0 1;...
       0 0 -d4+L(2)+cube_size(4) 1;...
       0 0 0 1;...
       i 0 L(3) 1]';

% positions for the joints, used to draw arm. Positions again given
% in respective coordinate system i
joints =[0 0 0 1;...
	 0 0 0 1;...
	 0 0 0 1;...
	 0 0 0 1;...
	 0 0 0 1;...
	 0 0 0 1;]';

colors = ['rgbcmyk'];
robot_arm = [al_im1 a_im1 d_i theta_i];
