// this is a -*- C++ -*- file
//----------------------------------------------------------------------
/*!\file    KinematicGroup.h
 *
 * \author   Kay-Ulrich Scholl
 * \date    06.11.02
 * \update  04.05.05 by Christian Smith
 *
 * $Id: KinematicGroup.h,v 1.1 2002/11/06 16:08:23 scholl Exp $
 *
 * \brief   Contains tKinematicGroup
 *
 * \b tKinematicGroup
 *
 * A few words for tKinematicGroup
 *
 */
//----------------------------------------------------------------------

#ifndef _KinematicGroup_h_
#define _KinematicGroup_h_
//----------------------------------------------------------------------
// System Includes - include with <>
//----------------------------------------------------------------------
#include <Group.h>
#include <descr.h>
//----------------------------------------------------------------------
// Project Includes - include with ""
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Extern methods and global vars
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Forward class declarations
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Implementation
//----------------------------------------------------------------------

//! Short description of tKinematicGroup
/*! A more detailed description of tModule_Name, which
     Kay-Ulrich Scholl hasn't done till now !!

    This group uses the following modules:
    \arg A t? Module for ...

*/
class tKinematicGroup:public tGroup
{
public:
  /*!
    Anonymous enumeration typ which contains the indices of the
    controller inputs.
   */
  _DESCR(tKinematicGroup::ci_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eCI_TOOL_X,
    eCI_TOOL_Y,
    eCI_TOOL_Z,
    eCI_TOOL_O,
    eCI_TOOL_A,
    eCI_TOOL_T,
    eCI_ARM,
    eCI_ELBOW,
    eCI_WRIST,
    eCI_FLIP,
    eCI_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    controller outputs.
   */
  _DESCR(tKinematicGroup::co_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eCO_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    sensor inputs.
   */
  _DESCR(tKinematicGroup::si_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eSI_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    sensor outputs.
   */
  _DESCR(tKinematicGroup::so_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eSO_TOOL_X,
    eSO_TOOL_Y,
    eSO_TOOL_Z,
    eSO_TOOL_O,
    eSO_TOOL_A,
    eSO_TOOL_T,
    eSO_ARM_TOGGLE,
    eSO_ELBOW_TOGGLE,
    eSO_WRIST_TOGGLE,
    eSO_FLIP_TOGGLE,
    eSO_OVERFLOW,
    eSO_WAIST,
    eSO_SHOULDER,
    eSO_ELBOW,
    eSO_WRIST_ROT,
    eSO_WRIST_BEND,
    eSO_FLANGE,
    eSO_WAIST_TRQ,
    eSO_SHOULDER_TRQ,
    eSO_ELBOW_TRQ,
    eSO_WRIST_ROT_TRQ,
    eSO_WRIST_BEND_TRQ,
    eSO_FLANGE_TRQ,

    eSO_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Descriptions of the controller inputs
  */
  static const tDescription ci_description[];
  /*!
    Descriptions of the controller outputs
  */
  static const tDescription co_description[];
  /*!
    Descriptions of the sensor inputs
   */
  static const tDescription si_description[];
  /*!
    Descriptions of the sensor outputs
   */
  static const tDescription so_description[];

  /*!
   */
  tKinematicGroup(tParent *parent,
	       tDescription name="KinematicGroup",bool fixtit=true);
  /*!
   */
  ~tKinematicGroup();
  /*!
   */

private:
};

#endif
