#include <stdio.h>
#include "../include/vectorMath.h"
#include "../include/robot_arm_params.h"

int trackval = -1;
double a[3]={1.1, 1.5, 1.9};
double b[3]={3.2, 1.2, 6.0};
double d[3];
double e[3];
double VM_Matrix[3][3]={{2, 0, 0},{0, 2, 0},{0, 0, 2}};
double c;
VM_3vector a3;
VM_3vector b3;
VM_3vector c3;
VM_6vector a6;
VM_6vector b6;
VM_3matrix A3[2];
VM_3matrix B3;
VM_6matrix A6;

struct VM_300matrix{
  double coord[300][300];
};

VM_300matrix A300;

inline VM_300matrix VM_inverseSym(const VM_300matrix A){
  trackval=2;
  VM_300matrix _C;
  VM_300matrix _I;
  int _ri[300]; // row index

  for(int i=0;i<300;i++){
    for(int j=i;j<300;j++){
      _C.coord[i][j] = (_C.coord[j][i] =  A.coord[i][j]);
      _I.coord[i][j] = (_I.coord[j][i] = (double)(i==j));
    }
    _ri[i]=i;
  }
  
  //trackval=3;
  for(int i=0;i<300;i++){
    
    // find largest element in column i
    double _max_val=0.0;
    int _max_pos = 0;
    for(int j=i;j<300;j++){
      if(fabs(_C.coord[_ri[j]][i])>_max_val){
	_max_val = fabs(_C.coord[_ri[j]][i]);
	_max_pos = j;
      }
    }

    //switch rows:
    int _tmp=_ri[i];
    _ri[i]=_ri[_max_pos];
    _ri[_max_pos]=_tmp;

    // normalize row i
    double _temp_div = _C.coord[_ri[i]][i];
    for(int j=0;j<300;j++){
      _I.coord[_ri[i]][j]=_I.coord[_ri[i]][j]/_temp_div;
      _C.coord[_ri[i]][j]=_C.coord[_ri[i]][j]/_temp_div;
    }

    // eliminate lower rows
    if(i<(300-1)){
      for(int j=i+1; j<300; j++){
	double _temp_mul =  _C.coord[_ri[j]][i];
	for(int k=0; k<300; k++){
	  _I.coord[_ri[j]][k] -= _temp_mul*_I.coord[_ri[i]][k];
	  _C.coord[_ri[j]][k] -= _temp_mul*_C.coord[_ri[i]][k];
	}
      }
    }

  }
 
  // eliminate upper rows
  for(int i=(300-2); i>(-1); i--){
    for(int j=0; j<(i+1); j++){
      for(int k=0; k<300; k++){
	_I.coord[_ri[j]][k] -= _C.coord[_ri[j]][i+1]*_I.coord[_ri[i+1]][k];
      }
    }
  }

  VM_300matrix _Iout;
  for(int i=0; i<300; i++){
    for(int j=0; j<300; j++){
      _Iout.coord[i][j] = _I.coord[_ri[i]][j];
    }
  }

  return _Iout;
}


int main(){
  //  trackval = 0;
  //fprintf(stdout,"Running test\n");
  fflush(stdout);

  //for(int i=0;i<100000;i++){
  //c = VM_3vector_dot(a,b);
  // VM_3vector_cross(a,a,d);
  //VM_3matrix_vector_mult(VM_Matrix,a,e);
  //}
  
 
  
  /*
  for(int i=0;i<6;i++){
    a6.coord[i] = 1;
    for(int j=i;j<6;j++){
      A6.coord[i][j] = A6.coord[j][i] = (i+j)*(1-2*((i%2)==(j%3)));
    }
  }
  */


  for(int i=0;i<300;i++){
    for(int j=i;j<300;j++){
      A300.coord[i][j] = A300.coord[j][i] = (i+j)*(1-2*((i%2)==(j%3)));
    }
  }



  VM_6matrix Invers6;
  VM_300matrix Invers300;
  
  /*
  for(int i=0;i<100000;i++){
    Invers6 = VM_inverseSym(A6);
  }
  */

  //fprintf(stdout,"before");
  //trackval=1;
  Invers300 = VM_inverseSym(A300);
  //fprintf(stdout,"...after\n");

  /*
  for(int i=0;i<1000000;i++){
    b6 = VM_mul(A6,a6);
  }
  */

  /*
  fprintf(stdout,"\n");
  for(int i=0;i<6;i++){
    fprintf(stdout,"[ ");
    for(int j=0;j<6;j++){
      fprintf(stdout,"%f ",A6.coord[i][j]);
    }
    fprintf(stdout,"]\n");
  }
  */

  /*
  fprintf(stdout,"\n");
  for(int i=0;i<6;i++){
    fprintf(stdout,"[ ");
    for(int j=0;j<6;j++){
      fprintf(stdout,"%f ",Invers6.coord[i][j]);
    }
    fprintf(stdout,"]\n");
  }
  */
  
  //fprintf(stdout, "x=%f, y=%f, z=%f\n",a3.coord[0],a3.coord[1],a3.coord[2]);
  //fprintf(stdout, "x=%f, y=%f, z=%f\n",b3.coord[0],b3.coord[1],b3.coord[2]);
  //  fprintf(stdout, "x=%f, y=%f, z=%f\n",c3.coord[0],c3[1].coord[1],c3[1].coord[2]);
  
  //  fprintf(stdout, "x=%f, y=%f, z=%f\n",e[0],e[1],e[2]);
  //fprintf(stdout, "x=%f\n",c);
  //fflush(stdout);
  return 1;
}

