// This program was written by Christian Smith May 09 2005
// modified May 09 2005
//
// Based on the sourde code "PumaKinematic.C" included in the puma
// tutorial for MCA2
//
// This is for generating an autodemo, that runs the robot through a
// predefined set of moves and positions.


#include "KinematicGroup_autodemo.h"
#include "Main.h"

void initPartDescription()
{
  SetProgramDescription("\n This Program simulates a PowerCube robot and\n"
			"calculates direct and inverse kinematics.\n");
}

int startup(tPart* part)
{
  tKinematicGroup_autodemo *powercube=new tKinematicGroup_autodemo(part);
  if (powercube->Status()==eERROR)
    {
      DEM("Could not create module KinematicGroup\n");
      return -1;
    }
  // Execute as usual
  return part->Execute(tTime().FromMSec(30));
}

void shutdown(tPart* part){}
