// PumaJoints.C
// Written by Christian Smith Apr 29 2005
// Updated by Christian Smith May 04 2005
//
// This is a rewrite of the source code with the following
// original credits:
//
// this is a -*- C++ -*- file
//----------------------------------------------------------------------
/*!\file    PumaJoints.h
 *
 * \author   Kay-Ulrich Scholl
 * \date    06.11.02
 *
 * $Id: PumaJoints.C,v 1.2 2003/01/10 16:59:30 gassmann Exp $
 *
 */
//----------------------------------------------------------------------
// Includes
//----------------------------------------------------------------------

#include "PowerJoints.h"

#define LOCAL_DEBUG
#include <local_debug.h>
#include "JointSimulation.h"
#include "JointControl.h"
#include "Dynamics.h"

//----------------------------------------------------------------------
// defines and consts
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// class PowerJoints
//----------------------------------------------------------------------
tPowerJoints::tPowerJoints(tParent *parent,tDescription name,bool fixit)
  :tGroup(parent, name,
	  eSI_DIMENSION, eSO_DIMENSION, eCI_DIMENSION, eCO_DIMENSION,
	  si_description, so_description, ci_description, co_description)
{
  char buffer[200];
  float min,max,v,trq;
  float ctrl_max_vel[6];
  float ctrl_torque[6];
  tAttributesStruct attributes[]=
  {
    tAttributeFloat("min",min),
    tAttributeFloat("max",max),
    tAttributeFloat("v",v),
    tAttributeFloat("torque",trq),
    tAttributeFieldEnd()
  };

  tJointControl *contrl=new tJointControl(this);
  mDynamics *dyn=new mDynamics(this);

  AddEdgeDown(this,contrl);
  AddEdgeDown(contrl,dyn);
  AddEdgeUp(dyn,this,6,0,18,1,19,2,20,3,21,4,22,5,23);

  for (int i=0;i<6;i++){
    // create module
    tJointSimulation *joint=new tJointSimulation(this,ci_description[i]);
    // Add Edges
    AddEdgeDown(dyn,joint,1,i,0);
    AddEdgeUp(joint,this,3,0,i,1,i+6,2,i+12);
    AddEdgeUp(joint,contrl,2,0,i,1,i+6);
    AddEdgeUp(joint,dyn,3,0,i,1,i+6,2,i+12);
    // fflush(stdout);
    // Get Attributes and Set as Parameters:
    strcpy(buffer,"power.joints.");
    strcat(buffer,ci_description[i]);
    if (!GetAttributes(attributes,buffer,true)){
      DEM("%s: could not be initialized because of missing attributes!\n", Description());
      SetStatus(eERROR);
      return;
    }
    
    ctrl_max_vel[i] = v;
    ctrl_torque[i] = trq;

    joint->SetParameters(tJointSimulation::ePAR_DIMENSION,
			 tJointSimulation::ePAR_MIN_ANGLE,Deg2Rad(min),
			 tJointSimulation::ePAR_MAX_ANGLE,Deg2Rad(max),
			 tJointSimulation::ePAR_ANGULAR_VELOCITY,Deg2Rad(v));
  
  }

  contrl->SetParameters(tJointControl::ePAR_DIMENSION,
			tJointControl::ePAR_MAX_ANG_VEL_WAIST,Deg2Rad(ctrl_max_vel[0]),
			tJointControl::ePAR_MAX_ANG_VEL_SHOULDER,Deg2Rad(ctrl_max_vel[1]),
			tJointControl::ePAR_MAX_ANG_VEL_ELBOW,Deg2Rad(ctrl_max_vel[2]),
			tJointControl::ePAR_MAX_ANG_VEL_WRIST_ROT,Deg2Rad(ctrl_max_vel[3]),
			tJointControl::ePAR_MAX_ANG_VEL_WRIST_BEND,Deg2Rad(ctrl_max_vel[4]),
			tJointControl::ePAR_MAX_ANG_VEL_FLANGE,Deg2Rad(ctrl_max_vel[5]));

  dyn->SetParameters(mDynamics::ePAR_DIMENSION,
		     mDynamics::ePAR_MAX_TORQUE_WAIST,ctrl_torque[0],
		     mDynamics::ePAR_MAX_TORQUE_SHOULDER,ctrl_torque[1],
		     mDynamics::ePAR_MAX_TORQUE_ELBOW,ctrl_torque[2],
		     mDynamics::ePAR_MAX_TORQUE_WRIST_ROT,ctrl_torque[3],
		     mDynamics::ePAR_MAX_TORQUE_WRIST_BEND,ctrl_torque[4],
		     mDynamics::ePAR_MAX_TORQUE_FLANGE,ctrl_torque[5]);
  
  if (fixit)
    FixIt();
}

tPowerJoints::~tPowerJoints()
{
}
