// this is a -*- C++ -*- file
//----------------------------------------------------------------------
/*!\file    JointSimulation.h
 *
 * \author   Kay-Ulrich Scholl
 * \date    06.11.02
 *
 * $Revision: 1.1 $
 * $Id: JointSimulation.h,v 1.1 2002/11/06 15:17:54 scholl Exp $
 *
 * \brief   Contains tJointSimulation
 *
 * \b tJointSimulation
 *
 * A few words for tJointSimulation
 *
 */
//----------------------------------------------------------------------

#ifndef _JointSimulation_h_
#define _JointSimulation_h_
//----------------------------------------------------------------------
// System Includes - include with <>
//----------------------------------------------------------------------
// z.B. #include <stdio.h>
#include <Module.h>
#include <descr.h>
//----------------------------------------------------------------------
// Project Includes - include with ""
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Extern methods and global vars
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Forward class declarations
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Implementation
//----------------------------------------------------------------------

//! Short description of tJointSimulation
/*! A more detailed description of tJointSimulation, which
     Kay-Ulrich Scholl hasn't done till now !!
*/
class tJointSimulation:public tModule
{
public:
  /*!
    Anonymous enumeration typ which contains the indices of the
    controller inputs.
   */
  _DESCR(tJointSimulation::ci_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eCI_JOINT_ACC, /*!< desired acceleration of joint */
    eCI_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    controller outputs.
   */
  _DESCR(tJointSimulation::co_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eCO_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    sensor inputs.
   */
  _DESCR(tJointSimulation::si_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eSI_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    sensor outputs.
   */
  _DESCR(tJointSimulation::so_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eSO_CURRENT_JOINT_VALUE, /*!< simulated joint angle value */
    eSO_JOINT_VELOCITY, /*!< simulated joint angle velocity */
    eSO_JOINT_ACC, /*!< simulated joint angle acceleration */
    eSO_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    parameters.
   */
  enum {
    ePAR_MIN_ANGLE, /*!< Minimum joint angle */
    ePAR_MAX_ANGLE, /*!< Maximum joint angle */
    ePAR_ANGULAR_VELOCITY, /*!< angular velocity of the joint */
    ePAR_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Descriptions of the controller inputs
  */
  static const tDescription ci_description[];
  /*!
    Descriptions of the controller outputs
  */
  static const tDescription co_description[];
  /*!
    Descriptions of the sensor inputs
   */
  static const tDescription si_description[];
  /*!
    Descriptions of the sensor outputs
   */
  static const tDescription so_description[];
  /*!
   */
  tJointSimulation(tParent *parent,
	       tDescription name="JointSimulation",bool fixit=true);
  /*!
   */
  ~tJointSimulation();
  /*!
   */
  void Control();
  /*!
   */
  void Sense();
  /*!
   */
  void Exception(tExceptionType type);
  
private:
  float new_angle,old_angle;
  float min_angle_value,max_angle_value,max_angular_velocity,max_angular_acc;
  double angular_vel;
  tTime sense_timer;
};

#endif
