//
// You received this file as part of MCA2
// Modular Controller Architecture Version 2
//
//Copyright (C) Forschungszentrum Informatik Karlsruhe
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// this is a -*- C++ -*- file
//----------------------------------------------------------------------
/*!\file    AutoDemoController.C
 *
 * \author   Christian Smith
 * \date     May 9 2005
 * \revised  June 13 2005
 *
 * $Revision: 1.5 $
 * $Id: NullModule.C,v 1.5 2003/02/24 14:36:21 gassmann Exp $
 *
 */
//----------------------------------------------------------------------
// Includes
//----------------------------------------------------------------------

#include "AutoDemoController.h"
#include "vectorMath.h"


//----------------------------------------------------------------------
// Module Debug
//----------------------------------------------------------------------
//#undef MODULE_DEBUG
#define MODULE_DEBUG
#include <module_debug.h>

//----------------------------------------------------------------------
// defines and consts
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// class AutoDemoController constructor
//----------------------------------------------------------------------
mAutoDemoController::mAutoDemoController(tParent *parent,
			   tDescription name,bool fixit)
  :tModule(parent,name,
	       eSI_DIMENSION,eSO_DIMENSION,eCI_DIMENSION,eCO_DIMENSION,
	       si_description,so_description,ci_description,co_description,
	       fixit)
{
  InitParameter(ePAR_DIMENSION,
		new tParameterBool("bool",false),
		new tParameterInt("int",0,100,10), //min,max,value
		new tParameterFloat("float",0.4,10.33,2.55), //min,max,value
		new tParameterString("string",100,"hello world") //max length, default
		);
}

//----------------------------------------------------------------------
// class AutoDemoController destructor
//----------------------------------------------------------------------
mAutoDemoController::~mAutoDemoController()
{
}

//----------------------------------------------------------------------
// class AutoDemoController Control
//----------------------------------------------------------------------
void  mAutoDemoController::Control()
{
  // calculate the elapsed time from last access to control
  double elapsed_time =(tTime::Now()-ADC_sense_timer).ToMSec()*0.001;

  if (elapsed_time>ADC_PERIOD){
    ADC_sense_timer.FromNow();
    
    if(ADC_startupcounter>0){
      ADC_startupcounter--;
    }
    else{
      ADC_pointcounter = ((++ADC_pointcounter)%ADC_NUMBER_OF_POINTS);
    
      //fprintf(stdout,"Running setControlOut");
      for (int i=0;i<ControllerOutputDimension();i++){
	SetControllerOutput(i,ADC_point[ADC_pointcounter][i]);
	//fprintf(stdout,".");
      }
      //fprintf(stdout,"done\n");

      SetControllerOutputChanged();
    }
  }
  else{
    ClearControllerOutput();
  }

}

//----------------------------------------------------------------------
// class AutoDemoController Sense
//----------------------------------------------------------------------
void  mAutoDemoController::Sense()
{
  if (SensorInputChanged())
    {
      for (int i=0;i<SensorInputDimension();i++){
	SensorOutput(i)=SensorInput(i);
      }
      SetSensorOutputChanged();

      ClearSensorInput();
    }
  else
    ClearSensorOutput();
}

//----------------------------------------------------------------------
// class AutoDemoController Exception
//----------------------------------------------------------------------
void mAutoDemoController::Exception(tExceptionType type)
{
  switch (type)
    {
    case eET_ParameterChanged:
      {
	bool b=ParameterBool(ePAR_BOOL);
	int i=ParameterInt(ePAR_INT);
	float f=ParameterFloat(ePAR_FLOAT);
	tDescription s=ParameterString(ePAR_STRING);
	ClearParameter();
      }
      break;
    case eET_PrepareForFirstSense:
      break;
    case eET_PrepareForFirstControl:
      ADC_sense_timer.FromNow();
      ADC_initializePoints();
      ADC_startupcounter = 10;
      ADC_pointcounter = 0;
      break;
    case eET_PrepareForBreak:
      break;
    case eET_PrepareForRestart:
      break;
    }
}

void mAutoDemoController::ADC_initializePoints(void){
  static int _isinitialized = 0;
  if(!_isinitialized){
    _isinitialized = 1;

/*
    ADC_point[0][eCO_TOOL_X] = 400;
    ADC_point[0][eCO_TOOL_Y] = 300;
    ADC_point[0][eCO_TOOL_Z] = -50;
    ADC_point[0][eCO_TOOL_O] = PI/2; 
    ADC_point[0][eCO_TOOL_A] = 0;
    ADC_point[0][eCO_TOOL_T] = -PI;
    ADC_point[0][eCO_ARM] = 1;
    ADC_point[0][eCO_ELBOW] = 1;
    ADC_point[0][eCO_WRIST] = 1;
    ADC_point[0][eCO_FLIP] = 1;

    ADC_point[1][eCO_TOOL_X] = 400;
    ADC_point[1][eCO_TOOL_Y] = -300;
    ADC_point[1][eCO_TOOL_Z] = -50;
    ADC_point[1][eCO_TOOL_O] = PI/2; 
    ADC_point[1][eCO_TOOL_A] = 0;
    ADC_point[1][eCO_TOOL_T] = -PI;
    ADC_point[1][eCO_ARM] = 1;
    ADC_point[1][eCO_ELBOW] = 1;
    ADC_point[1][eCO_WRIST] = 1;
    ADC_point[1][eCO_FLIP] = 1;

    ADC_point[2][eCO_TOOL_X] = 400;
    ADC_point[2][eCO_TOOL_Y] = -300;
    ADC_point[2][eCO_TOOL_Z] = 550;
    ADC_point[2][eCO_TOOL_O] = PI/2; 
    ADC_point[2][eCO_TOOL_A] = 0;
    ADC_point[2][eCO_TOOL_T] = -PI;
    ADC_point[2][eCO_ARM] = 1;
    ADC_point[2][eCO_ELBOW] = 1;
    ADC_point[2][eCO_WRIST] = 1;
    ADC_point[2][eCO_FLIP] = 1;

    ADC_point[3][eCO_TOOL_X] = 400;
    ADC_point[3][eCO_TOOL_Y] = -300;
    ADC_point[3][eCO_TOOL_Z] = -50;
    ADC_point[3][eCO_TOOL_O] = PI/2; 
    ADC_point[3][eCO_TOOL_A] = 0;
    ADC_point[3][eCO_TOOL_T] = -PI;
    ADC_point[3][eCO_ARM] = 1;
    ADC_point[3][eCO_ELBOW] = 1;
    ADC_point[3][eCO_WRIST] = 1;
    ADC_point[3][eCO_FLIP] = 1;

    ADC_point[4][eCO_TOOL_X] = 400;
    ADC_point[4][eCO_TOOL_Y] = 300;
    ADC_point[4][eCO_TOOL_Z] = 550;
    ADC_point[4][eCO_TOOL_O] = PI/2; 
    ADC_point[4][eCO_TOOL_A] = 0;
    ADC_point[4][eCO_TOOL_T] = -PI;
    ADC_point[4][eCO_ARM] = 1;
    ADC_point[4][eCO_ELBOW] = 1;
    ADC_point[4][eCO_WRIST] = 1;
    ADC_point[4][eCO_FLIP] = 1;

    ADC_point[5][eCO_TOOL_X] = 400;
    ADC_point[5][eCO_TOOL_Y] = -300;
    ADC_point[5][eCO_TOOL_Z] = 550;
    ADC_point[5][eCO_TOOL_O] = PI/2; 
    ADC_point[5][eCO_TOOL_A] = 0;
    ADC_point[5][eCO_TOOL_T] = -PI;
    ADC_point[5][eCO_ARM] = 1;
    ADC_point[5][eCO_ELBOW] = 1;
    ADC_point[5][eCO_WRIST] = 1;
    ADC_point[5][eCO_FLIP] = 1;
*/

    for(int i=0;i<ADC_NUMBER_OF_POINTS;i++){
      ADC_point[i][eCO_TOOL_X] = 400;
      ADC_point[i][eCO_TOOL_Y] = 0 + cos((i/(double)ADC_NUMBER_OF_POINTS)*2*PI)*300;
      ADC_point[i][eCO_TOOL_Z] = 250 + sin((i/(double)ADC_NUMBER_OF_POINTS)*2*PI)*300;
      ADC_point[i][eCO_TOOL_O] = PI/2; 
      ADC_point[i][eCO_TOOL_A] = 0;
      ADC_point[i][eCO_TOOL_T] = -PI;
      ADC_point[i][eCO_ARM] = 1;
      ADC_point[i][eCO_ELBOW] = 1;
      ADC_point[i][eCO_WRIST] = 1;
      ADC_point[i][eCO_FLIP] = 1;
    }
  }
}
