// this is a -*- C++ -*- file
//----------------------------------------------------------------------
/*!\file    JointControl.h
 *
 * \author   Christian Smith
 * \date    2005.05.24
 *
 * $Revision: 1.1 $
 * $Id: JointControl.h,v 1.1 2002/11/06 15:17:54 scholl Exp $
 *
 * \brief   Contains tJointControl
 *
 * \b tJointControl
 *
 * A few words for tJointControl
 *
 */
//----------------------------------------------------------------------

#ifndef _JointControl_h_
#define _JointControl_h_
//----------------------------------------------------------------------
// System Includes - include with <>
//----------------------------------------------------------------------
// z.B. #include <stdio.h>
#include <Module.h>
#include <descr.h>
//----------------------------------------------------------------------
// Project Includes - include with ""
//----------------------------------------------------------------------
#include "vectorMath.h"
//----------------------------------------------------------------------
// Extern methods and global vars
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Forward class declarations
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Implementation
//----------------------------------------------------------------------

//! Short description of tJointControl
/*! This file contains the control structure for the PowerArm
*/
class tJointControl:public tModule
{
public:
  /*!
    Anonymous enumeration typ which contains the indices of the
    controller inputs.
   */
  _DESCR(tJointControl::ci_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eCI_JOINT_VALUE_WAIST, /*!< desired angle value of waist joint */
    eCI_JOINT_VALUE_SHOULDER, /*!< desired angle value of shoulder joint */
    eCI_JOINT_VALUE_ELBOW, /*!< desired angle value of elbow joint */
    eCI_JOINT_VALUE_WRIST_ROT, /*!< desired angle value of wrist rot joint */
    eCI_JOINT_VALUE_WRIST_BEND, /*!< desired angle value of wrist bend joint */
    eCI_JOINT_VALUE_FLANGE, /*!< desired angle value of  flange joint */
    eCI_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    controller outputs.
   */
  _DESCR(tJointControl::co_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eCO_JOINT_ACC_WAIST, /*!< desired angular acc of waist joint */
    eCO_JOINT_ACC_SHOULDER, /*!< desired angular acc of shoulder joint */
    eCO_JOINT_ACC_ELBOW, /*!< desired angular acc of elbow joint */
    eCO_JOINT_ACC_WRIST_ROT, /*!< desired angular acc of wrist rot joint */
    eCO_JOINT_ACC_WRIST_BEND, /*!< desired angular acc of wrist bend joint */
    eCO_JOINT_ACC_FLANGE, /*!< desired angular acc of flange joint */
    eCO_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    sensor inputs.
   */
  _DESCR(tJointControl::si_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eSI_JOINT_VALUE_WAIST, /*!< actual angle value of waist joint */
    eSI_JOINT_VALUE_SHOULDER, /*!< actual angle value of shoulder joint */
    eSI_JOINT_VALUE_ELBOW, /*!< actual angle value of elbow joint */
    eSI_JOINT_VALUE_WRIST_ROT, /*!< actual angle value of wrist rot joint */
    eSI_JOINT_VALUE_WRIST_BEND, /*!< actual angle value of wrist bend joint */
    eSI_JOINT_VALUE_FLANGE, /*!< actual angle value of flange joint */
    eSI_JOINT_VEL_WAIST, /*!< actual angular vel of waist joint */
    eSI_JOINT_VEL_SHOULDER, /*!< actual angular vel of shoulder joint */
    eSI_JOINT_VEL_ELBOW, /*!< actual angular vel of elbow joint */
    eSI_JOINT_VEL_WRIST_ROT, /*!< actual angular vel of wrist rot joint */
    eSI_JOINT_VEL_WRIST_BEND, /*!< actual angular vel of wrist bend joint */
    eSI_JOINT_VEL_FLANGE, /*!< actual angular vel of flange joint */
    eSI_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    sensor outputs.
   */
  _DESCR(tJointControl::so_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eSO_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    parameters.
   */
  enum {
    ePAR_MAX_ANG_VEL_WAIST, /*!< maximum angular vel of waist joint */
    ePAR_MAX_ANG_VEL_SHOULDER, /*!< maximum angular vel of shoulder joint */
    ePAR_MAX_ANG_VEL_ELBOW, /*!< maximum angular vel of elbow joint */
    ePAR_MAX_ANG_VEL_WRIST_ROT, /*!< maximum angular vel of wrist rot joint */
    ePAR_MAX_ANG_VEL_WRIST_BEND, /*!< maximum angular vel of wrist bend joint */
    ePAR_MAX_ANG_VEL_FLANGE, /*!< maximum angular vel of flange joint */
    ePAR_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Descriptions of the controller inputs
  */
  static const tDescription ci_description[];
  /*!
    Descriptions of the controller outputs
  */
  static const tDescription co_description[];
  /*!
    Descriptions of the sensor inputs
   */
  static const tDescription si_description[];
  /*!
    Descriptions of the sensor outputs
   */
  static const tDescription so_description[];
  /*!
   */
  tJointControl(tParent *parent,
	       tDescription name="JointControl",bool fixit=true);
  /*!
   */
  ~tJointControl();
  /*!
   */
  void Control();
  /*!
   */
  void Sense();
  /*!
   */
  void Exception(tExceptionType type);
  
private:
  float new_angle[6],old_angle[6];
  float min_angle_value[6],max_angle_value[6],max_angular_velocity[6];
  float target_acc[6];
  double angular_vel[6];
  tTime sense_timer;
};

#endif
