//
// You received this file as part of MCA2
// Modular Controller Architecture Version 2
//
//Copyright (C) Forschungszentrum Informatik Karlsruhe
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// this is a -*- C++ -*- file
//----------------------------------------------------------------------
/*!\file    JointSimulation.h
 *
 * \author   Christian Smith
 * \date    25.04.05
 *
 * $Revision: 1.7 $
 * $Id: NullModule.h,v 1.7 2003/02/24 14:36:21 gassmann Exp $
 *
 * \brief   Contains mJointSimulation
 *
 * \b mJointSimulation
 *
 * A few words for mJointSimulation
 *
 */
//----------------------------------------------------------------------

#ifndef _JointSimulation_h_
#define _JointSimulation_h_
//----------------------------------------------------------------------
// System Includes - include with <>
//----------------------------------------------------------------------
// z.B. #include <stdio.h>
#include <Module.h>
#include <SystemTime.h>
#include <descr.h>
//----------------------------------------------------------------------
// Project Includes - include with ""
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Extern methods and global vars
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Forward class declarations
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Implementation
//----------------------------------------------------------------------

//! Short description of mJointSimulation
/*! A more detailed description of mJointSimulation, which
     Christian Smith hasn't done till now !!
*/
class mJointSimulation:public tModule
{
public:
  /*!
    Anonymous enumeration typ which contains the indices of the
    controller inputs.
   */
  _DESCR_(static,mJointSimulation::ci_description,4,Natural,cDATA_VECTOR_END_MARKER);
  enum {
    eCI_JOINT_VALUE, /*!< desired angle value of joint */
    eCI_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    controller outputs.
   */
  _DESCR_(static,mJointSimulation::co_description,4,Natural,cDATA_VECTOR_END_MARKER);
  enum {
    eCO_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    sensor inputs.
   */
  _DESCR_(static,mJointSimulation::si_description,4,Natural,cDATA_VECTOR_END_MARKER);
  enum {
    eSI_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    sensor outputs.
   */
  _DESCR_(static,mJointSimulation::so_description,4,Natural,cDATA_VECTOR_END_MARKER);
  enum {
    eSO_CURRENT_JOINT_VALUE, /*!< simulated joint angle value */
    eSO_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    parameters.
   */
  enum {
    ePAR_MIN_ANGLE, /*!< Minimum joint angle */
    ePAR_MAX_ANGLE, /*!< Maximum joint angle */
    ePAR_ANGULAR_VELOCITY, /*!< angular velocity of the joint */
    ePAR_DIMENSION /*!< Endmarker and Dimension */
  };

  /*! \param parent the parent
   *  \param name The module name
   *  \param fixit whether to use FixIt() or not
   */
  mJointSimulation(tParent *parent,
	       tDescription name="JointSimulation",bool fixit=true);
  /*!
   */
  ~mJointSimulation();
  /*!
   */
  void Control();
  /*!
  */
  void Sense();
  /*!
   */
  void Exception(tExceptionType type);
 private:
  float new_angle,old_angle;
  float min_angle_value,max_angle_value,angular_velocity;
  tTime sense_timer;
  
};

#endif
