// this is a -*- C++ -*- file
//----------------------------------------------------------------------
/*!\file    KinematicGroup.h
 *
 * written by Christian Smith Apr 29 2005
 * updated by Christian Smith May 04 2005
 *
 * This code is basically a rewrite of code by the same name,
 * with the original credits as follows:
 *
 * \author   Kay-Ulrich Scholl
 * \date    06.11.02
 *
 * $Id: KinematicGroup.C,v 1.1 2002/11/06 16:08:54 scholl Exp $
 *
 */
//----------------------------------------------------------------------
// Includes
//----------------------------------------------------------------------

#include "KinematicGroup.h"
#include "Kinematic.h"
#include "Dynamics.h"
#include "PowerJoints.h"
#define LOCAL_DEBUG
#include <local_debug.h>

//----------------------------------------------------------------------
// defines and consts
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// class KinematicGroup
//----------------------------------------------------------------------
tKinematicGroup::tKinematicGroup(tParent *parent,tDescription name,bool fixit)
  :tGroup(parent, name,
	  eSI_DIMENSION, eSO_DIMENSION, eCI_DIMENSION, eCO_DIMENSION,
	  si_description, so_description, ci_description, co_description)
{
  // create Modules:
  tKinematic *kin = new tKinematic(this);
  tPowerJoints *joints = new tPowerJoints(this);
  //dyn = new mDynamics(this);

  if (joints->Status()==eERROR)
    {
      SetStatus(eERROR);
      return;
    }

  // Edges:
  AddEdgeDown(this,kin);
  AddEdgeUp(kin,this,11,
	    tKinematic::eSO_TOOL_X,    eSO_TOOL_X,
	    tKinematic::eSO_TOOL_Y,    eSO_TOOL_Y,
	    tKinematic::eSO_TOOL_Z,    eSO_TOOL_Z,
	    tKinematic::eSO_TOOL_O,    eSO_TOOL_O,
	    tKinematic::eSO_TOOL_A,    eSO_TOOL_A,
	    tKinematic::eSO_TOOL_T,    eSO_TOOL_T,
	    tKinematic::eSO_ARM,    eSO_ARM_TOGGLE,
	    tKinematic::eSO_ELBOW,    eSO_ELBOW_TOGGLE,
	    tKinematic::eSO_WRIST,    eSO_WRIST_TOGGLE,
	    tKinematic::eSO_FLIP,    eSO_FLIP_TOGGLE,
	    tKinematic::eSO_OVERFLOW,    eSO_OVERFLOW);
  
  /*
  AddEdgeUp(dyn,this,6,
	    mDynamics::eSO_WAIST_TRQ, eSO_WAIST_TRQ,
	    mDynamics::eSO_SHOULDER_TRQ,  eSO_SHOULDER_TRQ,  
	    mDynamics::eSO_ELBOW_TRQ,     eSO_ELBOW_TRQ,     
	    mDynamics::eSO_WRIST_ROT_TRQ, eSO_WRIST_ROT_TRQ, 
	    mDynamics::eSO_WRIST_BEND_TRQ,eSO_WRIST_BEND_TRQ,
	    mDynamics::eSO_FLANGE_TRQ,   eSO_FLANGE_TRQ);   

  AddEdgeUp(joints,dyn);
  */

  AddEdgeUp(joints,this,6,
	    tPowerJoints::eSO_WAIST_TRQ, eSO_WAIST_TRQ,
	    tPowerJoints::eSO_SHOULDER_TRQ,  eSO_SHOULDER_TRQ,  
	    tPowerJoints::eSO_ELBOW_TRQ,     eSO_ELBOW_TRQ,     
	    tPowerJoints::eSO_WRIST_ROT_TRQ, eSO_WRIST_ROT_TRQ, 
	    tPowerJoints::eSO_WRIST_BEND_TRQ,eSO_WRIST_BEND_TRQ,
	    tPowerJoints::eSO_FLANGE_TRQ,   eSO_FLANGE_TRQ);   

  AddEdgeDown(kin,joints);
  AddEdgeUp(joints,kin,6,0,0,1,1,2,2,3,3,4,4,5,5);

  AddEdgeUp(joints,this,6,
	    tPowerJoints::eSO_WAIST,      eSO_WAIST,
	    tPowerJoints::eSO_SHOULDER,   eSO_SHOULDER,
	    tPowerJoints::eSO_ELBOW,      eSO_ELBOW,
	    tPowerJoints::eSO_WRIST_ROT,  eSO_WRIST_ROT,
	    tPowerJoints::eSO_WRIST_BEND, eSO_WRIST_BEND,
	    tPowerJoints::eSO_FLANGE,     eSO_FLANGE);

  if (fixit)
    FixIt();
}

tKinematicGroup::~tKinematicGroup()
{
}
