#ifndef _PACKET_TYPEDEF
#define _PACKET_TYPEDEF


#define VISION_IP "192.168.218.22" 
#define ROBOT_IP "192.168.218.22" 
#define ROBOT_IP_AUTONOMOUS "192.168.218.21" 
#define VISION_PROXY_IP "130.237.218.17"
#define ROBOT_PROXY_IP "130.237.218.17"

#define ROBOT_IP_PROXY "192.168.218.21" 

#define ROBOT_UDP_PORT 18756 
#define VISION_UDP_PORT 18757 
#define ROBOT_PROXY_UDP_PORT 18766 
#define VISION_PROXY_UDP_PORT 18767  
//#define ROBOT_UDP_PORT ROBOT_PROXY_UDP_PORT 


#define ROBOT_UDP_PORT_PROXY 18766 
#define VISION_UDP_PORT_PROXY 18767 

//#define ROBOT_IP "130.237.218.136" 
//#define ROBOT_UDP_PORT 18755 

#define PKT_CMD_QUIT 0
#define PKT_CMD_POS 1
#define PKT_CMD_VEL 2
#define PKT_CMD_DUMMY 3
#define PKT_CMD_RESET 4
#define PKT_CMD_POSVEL 5
#define PKT_CMD_AUTOCATCH 6
#define PKT_CMD_BRAKE 7

#define PKT_RSP_OK 0
#define PKT_RSP_ERR 1
#define PKT_RSP_DUMMY 2

// The following are in rad/s, and are currently set _very_ low
// for safety reasons. Values are stored in 'float cube_max_acc[6]'
// and 'float cube_max_vel[6]'
/* #define INNER_CUBE_ACC 6.0 //3.0 */
/* #define INNER_CUBE_VEL 6.0 //3.0 */
/* #define OUTER_CUBE_ACC 20.0 //3.0 */
/* #define OUTER_CUBE_VEL 6.0 //3.0 */



#define INNER_CUBE_ACC_RT 3.5
#define INNER_CUBE_VEL_RT 3.5
#define OUTER_CUBE_ACC_RT 10.0
#define OUTER_CUBE_VEL_RT 4.0

#define INNER_CUBE_ACC 3.0
#define INNER_CUBE_VEL  3.0
#define OUTER_CUBE_ACC  10.0
#define OUTER_CUBE_VEL  4.0

/* #define INNER_CUBE_ACC_RT 1.5 */
/* #define INNER_CUBE_VEL_RT 1.5 */
/* #define OUTER_CUBE_ACC_RT 10.0 */
/* #define OUTER_CUBE_VEL_RT 4.0 */


// control packets are sent from the client, and contain a command,
// a target position, and a time when the command should be executed.
// if the command is *_VEL, then the coordinates should be considered 
// to be the corresponding velocities..
/* struct control_packet{ */
/*   int command; */
/*   float x; */
/*   float y; */
/*   float z; */
/*   float p; */
/*   float t; */
/*   float a;   */
/*   struct timeval execute_time; */
/*   struct timeval send_time;   */
/* }; */

// Larger control packet with pos and vel.
// If command is *_POS or *_VEL, consider only the corresponding part of the struct. 
// If command is *_POSVEL, consider both parts.
struct posvel_control_packet{
  int command;
  float x;
  float y;
  float z;
  float xvel;
  float yvel;
  float zvel;
  float p;
  float t;
  float a;  
  float pvel;
  float tvel;
  float avel;  
  struct timeval execute_time;
  struct timeval send_time;  
};


// the server response, contains positions and velocities in both
// cartesian and joint space, as well as the time of the measurement.
struct response_packet{
  int status;
  float x;
  float y;
  float z;
  float p;
  float t;
  float a;  
  float xv;  // v is for velocity 
  float yv;
  float zv;
  float pv;
  float tv;
  float av;  
  float theta[6];
  float thetav[6];
  struct timeval command_send_time;
  struct timeval measurement_time;
  struct timeval send_time;  
};

//For vision server --> user interface communication
//Packet for sending state of kalman filter from vision server
//or for syncing vision and ui clocks
#define KALMAN_PKT 1
#define SYNC_PKT 2
#define POSITION_PKT 3    // used for vision only position (no EKF)
#define UI_READY_PKT 4
#define WARNING_PKT 5
#define END_TRAJECTORY_PKT 6  // ball has reached end of trajectory

struct vision2ui_packet{
  int type;  //on of those just #defined 
  float x[6];  //state vector (not in SYNC_PKT)
  float P[6][6]; //covariance matrix (not in SYNC or POSITION_PKT)
  struct timeval t; //time of measurement (KALMAN_PKT) or first send time (SYNC_PKT)
  struct timeval t2; //second send time (only SYNC_PKT)
};

/* Borde väl inte vara i headerfilen? Jag får länkarfel: multiple definition
float cube_max_acc[6] = {INNER_CUBE_ACC,
			 INNER_CUBE_ACC,
			 INNER_CUBE_ACC,
			 OUTER_CUBE_ACC,
			 OUTER_CUBE_ACC,
			 OUTER_CUBE_ACC};
float cube_max_vel[6] = {INNER_CUBE_VEL,
			 INNER_CUBE_VEL,
			 INNER_CUBE_VEL,
			 OUTER_CUBE_VEL,
			 OUTER_CUBE_VEL,
			 OUTER_CUBE_VEL};
*/

//struct posvel_control_packet poscom2posvelcom(struct control_packet _indata);

/*{
  struct posvel_control_packet _posvel;
  _posvel.command = _indata.command;
  _posvel.x = _indata.x;
  _posvel.y = _indata.y;
  _posvel.z = _indata.z;
  _posvel.xvel = 0.0;
  _posvel.yvel = 0.0;
  _posvel.zvel = 0.0;
  _posvel.p = _indata.p;#
  _posvel.t = _indata.t;
  _posvel.a = _indata.a;
  _posvel.pvel = 0.0;
  _posvel.tvel = 0.0;
  _posvel.avel = 0.0;  
  _posvel.execute_time = _indata.execute_time;
  _posvel.send_time = _indata.send_time;

  return _posvel;
}
*/

#endif

