function T = Tza(angles, Z)
%
% Tza(angles, Z)
% Function that returns the Euler transformation matrix of the proximal end of 
% the joint given the angles and the length of the proximal element, i.e. the 
% Z offset in that elements frame of reference
%
% Written by: Hedvig Sidenbladh, KTH, Sweden
% http://www.nada.kth.se/~hedvig/
% Date: March 2002

theta = angles(1);
fi = angles(2); 
tau = angles(3);

Rx = [1           0          0 
      0  cos(theta) sin(theta)
      0 -sin(theta) cos(theta)];

Ry = [cos(fi) 0  -sin(fi)
            0 1         0
      sin(fi) 0   cos(fi)];

Rz = [ cos(tau) sin(tau) 0
      -sin(tau) cos(tau) 0 
              0        0 1];

R = Rz*Ry*Rx;

t = -R*[0; 0; Z];

T = [R     t
     0 0 0 1];



