function T = Txyza(angles, offset)
%
% T = Txyza(angles, offset)
% Function that returns the Euler transformation matrix of the proximal end of 
% the spine of the human given the angles and the X, Y, Z offset from another 
% coordinate system.
%
% Written by: Hedvig Sidenbladh, KTH, Sweden
% http://www.nada.kth.se/~hedvig/
% Date: March 2002

theta = angles(1);
fi = angles(2);
tau = angles(3);

Rx = [1           0          0 
      0  cos(theta) sin(theta)
      0 -sin(theta) cos(theta)];

Ry = [cos(fi) 0  -sin(fi)
            0 1         0
      sin(fi) 0   cos(fi)];

Rz = [ cos(tau) sin(tau) 0
      -sin(tau) cos(tau) 0 
              0        0 1];

R = Rz*Ry*Rx;

t = -R*(offset');

T = [R     t
     0 0 0 1];

