function [c] = contains(polygon, point);
%
% [c] = contains(polygon, point);
% Returns 1 if the point lies within polygon
%
% Written by: Hedvig Sidenbladh, KTH, Sweden
% http://www.nada.kth.se/~hedvig/
% Date: March 2002

c = (((point(1) - polygon(1,4))*(polygon(2,1) - polygon(2,4)) < ...
      (polygon(1,1) - polygon(1,4))*(point(2) - polygon(2,4))) & ...
     ((point(1) - polygon(1,1))*(polygon(2,2) - polygon(2,1)) < ...
      (polygon(1,2) - polygon(1,1))*(point(2) - polygon(2,1))) & ...
     ((point(1) - polygon(1,2))*(polygon(2,3) - polygon(2,2)) < ...
      (polygon(1,3) - polygon(1,2))*(point(2) - polygon(2,2))) & ...
     ((point(1) - polygon(1,3))*(polygon(2,4) - polygon(2,3)) < ...
      (polygon(1,4) - polygon(1,3))*(point(2) - polygon(2,3))));

    
