function [depthOrder] = limbDepth(state);
%
% [depthOrder] = limbDepth(state);
% Get the depth ordering (nearest limb index first) of the limbs, given the 
% camera and state
%
% Written by: Hedvig Sidenbladh, KTH, Sweden
% http://www.nada.kth.se/~hedvig/
% Date: March 2002


global CAMERA_CENTER;
global CAMERA_F;
global LEN;
global DISPLACE;



%%%%%%%%%%%
% CYLINDERS
    
% Transform from global to torso
Ttorso = Txyza(state(4:6), state(1:3));
% Transform from global to right shoulder
Trshoulder = Tza(state(7:9), 0)*Txyza([pi 0 0], DISPLACE)*Ttorso;
% Transform from global to right elbow
Trelbow = Tza([0 state(10) 0], LEN(2,1))*Trshoulder;

pos(:,1) = inv(Ttorso)*[0; 0; 0; 1];
pos(:,2) = inv(Trshoulder)*[0; 0; 0; 1];
pos(:,3) = inv(Trelbow)*[0; 0; 0; 1];

for i = 1:3
  normPos(i) = norm(pos(1:3,i));
end
[xPos depthOrder] = sort(normPos);
