function [point, oldPoint] = getCorrespondingPoints(corner, oldCorner);
%
% [point, oldPoint] = getCorrespondingPoints(corner, oldCorner);
% Get two corresponding points in the two boxes
%
% Written by: Hedvig Sidenbladh, KTH, Sweden
% http://www.nada.kth.se/~hedvig/
% Date: March 2002

% Random position between point 1 and 2 (or 3 and 4)
rrand = rand;

% Random position between elbow and hand
lrand = rand;

% Use these ratios to find corresponding points in the two boxes
p14 = lrand*corner(:, 1) + (1 - lrand)*corner(:, 4);
p23 = lrand*corner(:, 2) + (1 - lrand)*corner(:, 3);
point = rrand*p14 + (1 - rrand)*p23;
oldp14 = lrand*oldCorner(:, 1) + (1 - lrand)*oldCorner(:, 4);
oldp23 = lrand*oldCorner(:, 2) + (1 - lrand)*oldCorner(:, 3);
oldPoint = rrand*oldp14 + (1 - rrand)*oldp23;
