function [newStates, priorStates] = propagate(oldStates, oldSmoothPstates, ...
                                              oldStatesUnsorted, oldPstatesUnsorted);
%
% [newStates, priorStates] = propagate(oldStates, oldSmoothPstates, ...
%                                      oldStatesUnsorted, oldPstatesUnsorted);
% Propagate oldStates one time step using a model of constant velocity, and 
% return in newStates
%
% Written by: Hedvig Sidenbladh, KTH, Sweden
% http://www.nada.kth.se/~hedvig/
% Date: March 2002

global STATES_DEV;
global N;

% Position/Angle is changed with the corresponding velocity/angular velocity. 
% Velocity is assumed unchanged. 
% Add Gaussian noise with standard deviation STATES_DEV.
newStates(:, :, 1) = ...
  [oldStates(:, 1:10, 1) + oldStates(:, 11:20, 1), oldStates(:, 11:20, 1)] +...
  randn(N, 20).*(ones(N, 1)*STATES_DEV); 

% There are physical limits on the arm Euler angles!
% -pi < shoulder x angle "inward" < 0.25*pi
% -0.5*pi < shoulder y angle "forward"< 0.9*pi
% -0.5*pi < shoulder z angle "twist" < 0.5*pi 
% 0 < elbow angle < 0.9*pi
% If an angle "hits the boundary" the velocity is set to 0.

newStates(:, 7:10, 1) = ...
  min(ones(N, 1)*[0.25 0.9 0.5 0.9]*pi, ...
      max(ones(N, 1)*[-1 -0.5 -0.5 0]*pi, ...
          newStates(:, 7:10, 1)));

newStates(:, 17:20, 1) = ...
  newStates(:, 17:20, 1).*...
  (newStates(:, 17:20, 1) ~= ones(N, 1)*[0.25 0.9 0.5 0.9]*pi).*...
  (newStates(:, 17:20, 1) ~= ones(N, 1)*[-1 -0.5 -0.5 0]*pi);

% Append old state for flow computations
newStates(:, :, 2) = oldStates(:, :, 1);
 
% Compute correction factor 
% priorStates = (prob that this state could have been created by oldPstates) /
%               (oldSmoothPstates)

interestingOldStates = find(oldPstatesUnsorted > 0.00001);
for i = 1:N        % For each of the new states i
  nominator = 0;
  for j = interestingOldStates'  % Could it have been generated by old state j?
    % Norm sq distance between old sample j and old sample i 
    dist2 = sum(((oldStates(i, :, 1) - ...
                  oldStatesUnsorted(j, :, 1))./max(0.0001, STATES_DEV)).^2);
    nominator = nominator + ...
                oldPstatesUnsorted(j)*exp(-dist2/2);
  end

  if oldSmoothPstates(i) < 0.0000001;
    priorStates(i, 1) = 0;
  else
    priorStates(i, 1) = nominator/oldSmoothPstates(i);
  end
end
