function [cylinder] = state2cylinder(state, fi_length);
% 
% [cylinder] = state2cylinder(state);
% Get the end ellipses and edges of the two limbs, from the state vector
% Cylinders on the form:
%  |e1x e2x cyl1x cyl2x|
%  |e1y e2y cyl1y cyl2y| 
%
% Written by: Hedvig Sidenbladh, KTH, Sweden
% http://www.nada.kth.se/~hedvig/
% Date: March 2002


global CAMERA_CENTER;
global CAMERA_F;
global LEN;
global DISPLACE;


%%%%%%%%%%
% EDGES


corner = state2corner(state);


%%%%%%%%%%%
% CYLINDERS
    
% Transform from global to torso
Ttorso = Txyza(state(4:6), state(1:3));
% Transform from global to right shoulder
Trshoulder = Tza(state(7:9), 0)*Txyza([pi 0 0], DISPLACE)*Ttorso;
% Transform from global to right elbow
Trelbow = Tza([0 state(10) 0], LEN(2,1))*Trshoulder;

dfi = 2*pi/(fi_length - 1);
fi = 0:dfi:2*pi;

% For each of the limbs, compute a polygon
for limb = 1:3
  
  
  if (limb == 1)
    T = Ttorso;
  else if (limb == 2)
    T = Trshoulder;
  else if (limb == 3)
    T = Trelbow;
  end, end, end
  len = LEN(limb,1);
  xProxRad = LEN(limb,2);
  yProxRad = LEN(limb,3);
  xDistRad = LEN(limb,4);
  yDistRad = LEN(limb,5);

  cyl3D(:, 1:fi_length) = inv(T)*[xProxRad*cos(fi); yProxRad*sin(fi) 
     					                zeros(size(fi)); ones(size(fi))];
  cyl3D(:, fi_length + (1:fi_length)) = inv(T)*[xDistRad*cos(fi); yDistRad*sin(fi) 
					                                 len*ones(size(fi)) 
                                                ones(size(fi))];
  cylinder(:, :, limb) = [corner(:, [4 1 2 3], limb), ...
                          CAMERA_CENTER*ones(1, 2*fi_length) - ...
                          CAMERA_F*[cyl3D(3, :)./cyl3D(1, :) 
	                                 cyl3D(2, :)./cyl3D(1, :)]];
end

