function [corner] = state2corner(state);
% 
% [corner] = state2corner(state);
% Get the corners of the polygons representing the 3 limbs, from the state 
% vector
% Corners limb l on the form:
%  |x x x x|     2 1
%  |y y y y|     3 4
%
% Written by: Hedvig Sidenbladh, KTH, Sweden
% http://www.nada.kth.se/~hedvig/
% Date: March 2002


global CAMERA_CENTER;
global CAMERA_F;
global LEN;
global DISPLACE;

% Transform from global to torso
Ttorso = Txyza(state(4:6), state(1:3));
% Transform from global to right shoulder
Trshoulder = Tza(state(7:9), 0)*Txyza([pi 0 0], DISPLACE)*Ttorso;
% Transform from global to right elbow
Trelbow = Tza([0 state(10) 0], LEN(2,1))*Trshoulder;

% For each of the limbs, compute a polygon
for limb = 1:3
  
  if (limb == 1)
    T = Ttorso;
  else if (limb == 2)
    T = Trshoulder;
  else if (limb == 3)
    T = Trelbow;
  end, end, end
  len = LEN(limb,1);
  xProxRad = LEN(limb,2);
  yProxRad = LEN(limb,3);
  xDistRad = LEN(limb,4);
  yDistRad = LEN(limb,5);

  % Focal point in limb system
  focalPoint = T*[0; 0; 0; 1];

  % Cylinder angle to focal point
  alpha = atan2(focalPoint(2),focalPoint(1));

  % If Z down:    If Z up:
  %   
  %   2---1       4---3
  %   |   |       |   |
  %   3---4       1---2
  %
   
  points(:,1) = inv(T)*[ xProxRad*sin(alpha)
                        -yProxRad*cos(alpha)
                                           0
                                           1];
  points(:,2) = inv(T)*[-xProxRad*sin(alpha)
                         yProxRad*cos(alpha)
                                           0
                                           1];
  points(:,3) = inv(T)*[-xDistRad*sin(alpha)
                         yDistRad*cos(alpha)
                                         len
                                           1];
  points(:,4) = inv(T)*[ xDistRad*sin(alpha)
                        -yDistRad*cos(alpha)
                                         len
                                           1];
  imagePoints = CAMERA_CENTER*ones(1, 4) - ...
                CAMERA_F*[points(3, :)./points(1, :)
                          points(2, :)./points(1, :)];
  % Z down:
  %   
  %   2---1
  %   |   |
  %   3---4
  %
  if ((imagePoints(2,1) < imagePoints(2,4)) & (imagePoints(1,1) < imagePoints(1,2))) 
    temp = imagePoints(1,1); imagePoints(1,1) = imagePoints(1,2); imagePoints(1,2) = temp;
    temp = imagePoints(2,1); imagePoints(2,1) = imagePoints(2,2); imagePoints(2,2) = temp;
    temp = imagePoints(1,3); imagePoints(1,3) = imagePoints(1,4); imagePoints(1,4) = temp;
    temp = imagePoints(2,3); imagePoints(2,3) = imagePoints(2,4); imagePoints(2,4) = temp;
  end

  % Z up:
  %   
  %   4---3
  %   |   |
  %   1---2
  %
  if ((imagePoints(2,1) > imagePoints(2,4)) & (imagePoints(1,1) < imagePoints(1,2)))
    temp = imagePoints(1,1); imagePoints(1,1) = imagePoints(1,2); imagePoints(1,2) = temp;
    temp = imagePoints(2,1); imagePoints(2,1) = imagePoints(2,2); imagePoints(2,2) = temp;
    temp = imagePoints(1,3); imagePoints(1,3) = imagePoints(1,4); imagePoints(1,4) = temp;
    temp = imagePoints(2,3); imagePoints(2,3) = imagePoints(2,4); imagePoints(2,4) = temp;
  end

  % Z left:   Z right:
  %   
  %   3---2     1---4
  %   |   |     |   |
  %   4---1     2---3
  %
  if (imagePoints(2,1) == imagePoints(2,4)) 
    if ((imagePoints(2,1) < imagePoints(2,2)) & (imagePoints(1,1) > imagePoints(1,4))) 
      temp = imagePoints(1,1); imagePoints(1,1) = imagePoints(1,2); imagePoints(1,2) = temp;
      temp = imagePoints(2,1); imagePoints(2,1) = imagePoints(2,2); imagePoints(2,2) = temp;
      temp = imagePoints(1,3); imagePoints(1,3) = imagePoints(1,4); imagePoints(1,4) = temp;
      temp = imagePoints(2,3); imagePoints(2,3) = imagePoints(2,4); imagePoints(2,4) = temp;
    end
    if ((imagePoints(2,1) > imagePoints(2,2)) & (imagePoints(1,1) < imagePoints(1,4))) 
      temp = imagePoints(1,1); imagePoints(1,1) = imagePoints(1,2); imagePoints(1,2) = temp;
      temp = imagePoints(2,1); imagePoints(2,1) = imagePoints(2,2); imagePoints(2,2) = temp;
      temp = imagePoints(1,3); imagePoints(1,3) = imagePoints(1,4); imagePoints(1,4) = temp;
      temp = imagePoints(2,3); imagePoints(2,3) = imagePoints(2,4); imagePoints(2,4) = temp;
    end
  end




  corner(:,:,limb) = imagePoints;
end
