%RECTPULSE - Create a SeeMRI rectangular RF pulse object
%   
%   RF = RECTPULSE(B1, F, PHI, TP) creates a rectangular RF pulse with
%   amplitude B1, frequency F (in Hz), phase PHI (in radians) and
%   pulse time TP (in seconds).
%
%   RF = RECTPULSE(B1, F, PHI, TP, T0) adds pulse start time T0 (in
%   seconds).
%
%   See also RFPULSE, RFPULSE/PLOT, RFPULSE/POWSPEC
%
%   Copyright (c) 2010 Peter Nillius (nillius@mi.physics.kth.se)
%
 
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the
%   License. You may obtain a copy of the License at
%
%   http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
%   implied. See the License for the specific language governing
%   permissions and limitations under the License.

classdef RectPulse < RFPulse
   methods
           function rf = RectPulse(B1, f, phi, tp, t0)
           if nargin == 0
               EnvelopeAmplitude = 0;
           else
               EnvelopeAmplitude = B1;
           end
           if nargin < 5
               t0 = 0;
           end
           rf = rf@RFPulse(@(t) 1, B1, f, phi, tp, t0, tp);
           end
   end
end
