function varargout = demo_seemri(varargin)
% DEMO_SEEMRI M-file for demo_seemri.fig
%      DEMO_SEEMRI, by itself, creates a new DEMO_SEEMRI or raises the existing
%      singleton*.
%
%      H = DEMO_SEEMRI returns the handle to a new DEMO_SEEMRI or the handle to
%      the existing singleton*.
%
%      DEMO_SEEMRI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in DEMO_SEEMRI.M with the given input arguments.
%
%      DEMO_SEEMRI('Property','Value',...) creates a new DEMO_SEEMRI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before demo_seemri_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to demo_seemri_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES
%
% Copyright (c) 2010 Peter Nillius
%
 
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the
%   License. You may obtain a copy of the License at
%
%   http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
%   implied. See the License for the specific language governing
%   permissions and limitations under the License.

% Edit the above text to modify the response to help demo_seemri

% Last Modified by GUIDE v2.5 12-Jul-2010 13:58:50

    
% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @demo_seemri_OpeningFcn, ...
                   'gui_OutputFcn',  @demo_seemri_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before demo_seemri is made visible.
function demo_seemri_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to demo_seemri (see VARARGIN)

% Choose default command line output for demo_seemri
handles.output = hObject;

% The examples
handles.examples = {
    {'RF excitation, 90 x''', 'ex_rf_90x'}, ...
    {'RF excitation, 90 y''', 'ex_rf_90y'}, ...
    {'RF excitation, Sinc', 'ex_rf_excitation_sinc'}, ...
    {'RF excitation, stationary frame', 'ex_rf_excitation_stat_frame'}, ...
    {'Gradient, x-direction', 'ex_gx'}, ...
    {'Gradient, y-direction', 'ex_gy'}, ...
    {'Spin Echo', 'ex_spin_echo'}, ...
    {'Slice selection', 'ex_slice_selection'}, ...
    {'Gradient Echo Imaging', 'ex_ge_imaging'}, ...
    {'GE Imaging, higher res, no plot', 'ex_ge_imaging_hires'}, ...
    {'Chemical Shift', 'ex_chemical_shift'}, ...
    {'Saturation Recovery', 'ex_sat_recov'}, ...
    {'Inversion Recovery', 'ex_inv_recov'}, ...
                   };

% Store some position information for resizing
set(handles.figure1, 'Units', 'characters');
set(handles.uipanel1, 'Units', 'characters');
set(handles.popupmenu1, 'Units', 'characters');
set(handles.pushbutton1, 'Units', 'characters');
figpos = get(handles.figure1, 'Position');
panelpos = get(handles.uipanel1, 'Position');
menupos = get(handles.popupmenu1, 'Position');
buttpos = get(handles.pushbutton1, 'Position');
handles.panelmarg = figpos(3:4)-panelpos(3:4);
handles.menumarg = figpos(4)-menupos(2);
handles.buttmarg = figpos(3:4)-buttpos(1:2)-[buttpos(3) 0];
handles.menuwidth = menupos(3)/figpos(3);
handles.buttwidth = buttpos(3)/figpos(3);
 
% Update menu
set(handles.popupmenu1, ...
    'String', cellfun(@(e) e{1}, handles.examples, 'UniformOutput', false))
set(handles.popupmenu1, 'Value', 1);

if ~isfield(handles, 'seemrifig')
    handles.seemrifig = figure;
end
% Run menu callback to load example code
popupmenu1_Callback(handles.popupmenu1, [], handles);

% Update handles structure
guidata(hObject, handles);


% This sets up the initial plot - only do when we are invisible
% so window can get raised using demo_seemri.
%if strcmp(get(hObject,'Visible'),'off')
%    plot(rand(5));
%end

% UIWAIT makes demo_seemri wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = demo_seemri_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%axes(handles.axes1);
%cla;

popup_sel_index = get(handles.popupmenu1, 'Value');
figure(handles.seemrifig)
clf
ex = handles.examples{popup_sel_index};
eval(ex{2});

% --- Executes on selection change in popupmenu1.
function popupmenu1_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu1

popup_sel_index = get(handles.popupmenu1, 'Value');
ex = handles.examples{popup_sel_index};
fid = fopen([ex{2} '.m']);
str = textscan(fid, '%s', 'Delimiter', '\n', 'Whitespace', '');
str = str{1};
fclose(fid);
set(handles.text1, 'String', str);
ext = get(handles.text1, 'Extent');
pos = get(handles.text1, 'Position');
set(handles.figure1, 'Position', get(handles.figure1, 'Position') ...
                  +[0 -ext(4)+pos(4) ext(3)-pos(3) ext(4)-pos(4)]);

% --- Executes during object creation, after setting all properties.
function popupmenu1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
     set(hObject,'BackgroundColor','white');
end

%set(hObject, ...
%    'String', cellfun(@(e) e{1}, handles.examples, 'UniformOutput', false))
%set(hObject, 'String', {'plot(rand(5))', 'plot(sin(1:0.01:25))', 'bar(1:.5:10)', 'plot(membrane)', 'surf(peaks)'});


% --- Executes on key press with focus on popupmenu1 and none of its controls.
function popupmenu1_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  structure with the following fields (see UICONTROL)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)


% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

close(handles.seemrifig);

% Hint: delete(hObject) closes the figure
delete(hObject);


% --- Executes when figure1 is resized.
function figure1_ResizeFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

figpos = get(hObject, 'Position');
buttpos = get(handles.pushbutton1, 'Position');
bw = figpos(3)*handles.buttwidth;
set(handles.pushbutton1, 'Position', ...
                  [figpos(3:4)-handles.buttmarg-[bw 0] ...
                   bw buttpos(4)]);
menupos = get(handles.popupmenu1, 'Position');
set(handles.popupmenu1, 'Position', ...
                  [menupos(1) figpos(4)-handles.menumarg ...
                   figpos(3)*handles.menuwidth menupos(4)]);
panelpos = get(handles.uipanel1, 'Position');

set(handles.uipanel1, 'Position', ...
                  [panelpos(1:2) figpos(3:4)-handles.panelmarg]);


% --- Executes when uipanel1 is resized.
function uipanel1_ResizeFcn(hObject, eventdata, handles)
% hObject    handle to uipanel1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

panelpos = get(handles.uipanel1, 'Position');
textpos = get(handles.text1, 'Position');
set(handles.text1, 'Position', [textpos(1:2) panelpos(3:4)-[3 2]]);
