gammabar = 42.58e6;
gamma = 2*pi*gammabar;

res = 0.3;
iv = waterandfat(6, res);

B0 = 3;

% RF pulse
tp = 1e-5;
B1 = pi/2/gamma/tp;
rf = RectPulse(B1, B0*gammabar, 0, tp);

% Sampling
W = 15;
dk_max = 1/W;
kmax = 1/res/2;
dk = kmax/ceil(kmax/dk_max)

% Gradients
TE = 50e-4;
tau = (TE-tp)/2;
Gpes = (-kmax:dk:kmax-dk)/gammabar/tau;
gx = Gradient([tp tp+tau], {Gpes 0});
Gfe = kmax/gammabar/tau;
gy = Gradient([tp tp+tau TE-tau TE+tau], [Gfe 0 -Gfe 0]);

% "Analog-to-digital converter"
dt = dk/gammabar/abs(Gfe);
adc = ADC(TE-tau, TE+tau, dt);

TR = 5;
[S, ts] = seemri(iv, B0, rf, gx, gy, adc, TR, length(Gpes), ...
                 'Plot', false);

mrireconstruct(S, kmax, 'Plot', true, 'Filter', 'Gauss');
title('Reconstructed Image')
